## Upgrade schedule
- [ ] TBD - `ember 1.13.0`
- [x] 9/8/15 - `ember 1.12.1`
- [x] 8/26/15 - `ember 1.11.3`
- [x] 7/6/15 - `ember 1.10.0`
- [x] 6/25/15 - `ember 1.9.1`
- [x] 6/15/15 - `ember 1.8.1`
- [x] 4/2/15 - `ember-cli 0.2.1`

We'd like to upgrade **a minor version every week** until we're caught up. Then,
we can update **a minor version every three weeks**. We assign this task each
week at the roadmap meeting.

## How to upgrade

If you have any doubts in this process, it's usually best to make a decision
yourself and then bring up your doubts during code review. If you find yourself
doing this often, ping someone.

### `ember`

1. Change the `ember` version in `bower.json`.
2. `rm -rf bower_components node_modules && npm install && bower install`
3. [CHANGELOG.md][ember-changelog] - Address breaking changes and deprecations.
4. It's sometimes useful to see all the packages that ship with a version of
   Ember. You can find this in [the blueprint app][ember-blueprint] in the
   `ember-cli` repository. For example, see [`bower.json`][ember-110-bower-json]
   and [`package.json`][ember-110-package-json] for ember 1.10.0. **Note** that
   I had to view the `ember-cli` tag corresponding to `ember 1.10.0`.

[ember-changelog]: https://github.com/emberjs/ember.js/blob/master/CHANGELOG.md
[ember-blueprint]: https://github.com/ember-cli/ember-cli/blob/master/blueprints/app/files/bower.json
[ember-110-bower-json]: https://github.com/ember-cli/ember-cli/blob/v0.2.1/blueprints/app/files/bower.json
[ember-110-package-json]: https://github.com/ember-cli/ember-cli/blob/v0.2.1/blueprints/app/files/package.json

### `ember-cli`

1. [How to update][cli-releases] (Scroll down to find your specific release.)
2. [CHANGELOG.md][cli-changelog] - Address breaking changes and deprecations.

After the diff step, ensure you delete `.travis.yml`.

#### After updating

If there are deprecation warnings, make tickets to address them. Decide on a
timeline for those tickets.

## QA Request

Here's the QA plan I've been sending:

```
Hi, QA!

Code Review: https://phabricator.internal.justin.tv/D###

Branches:

web-client: ember-X.X.X
web: master

Summary: Update our version of ember to X.X.X

Context:

This change primarily affects ember pages (not front page,
not /p/ pages, etc.).

Test Plan Checklist:

- Automated capybara tests [1]
- Parts of the website:
  - Directory [1]
  - Searching
  - Channel page
    - Profile image [1]
    - Recent Past Broadcast Upsell Banner [1]
  - Video and Ad playback
  - Chat [1]
    - Popout
    - Send/read messages
    - Viewer list [2]
  - Display ads
  - Highlight Manager [2]

[#] means that the feature has broken # times
in past upgrades (either in QA or production)

Thank you!
```

**If anything breaks during QA or after deploying**, please
update the QA request template above for future upgrades.

You're done!

[cli-releases]: https://github.com/ember-cli/ember-cli/releases
[cli-changelog]: https://github.com/ember-cli/ember-cli/blob/master/CHANGELOG.md
