# Formatting

**meta/formatting** is about setting consistent styles for docs pages. Feel free to fill in things that you feel
strongly about.

## Spaces in article titles

If you find yourself making an article whose English name has a space in it (e.g. "on call"), replace the space with an underscore in that article's filename (e.g. [on_call](../web/on_call.md)).

## Headings

Headings are cool, use them where appropriate. When embedded, heading levels should follow a standard progression from 1
to 6, without skipping numbers.

### Capitalization of headings

We use newspaper-style capitalization for our headings; capitalize only the first letter of the first word.

## Emphasis vs. strong

**Strong** should be used to signal key words or phrases, like the name of the current article, or words that need to be
pointed out as important. This is different from *emphasis*, which should mark words which, if read aloud, deserve
additional... well, emphasis.

A general rule of thumb is that emphasis should affect how people's internal voices stress words, whereas strong should
point out words that skimmers need to see, but might not otherwise.

Obviously, typical uses of each also apply, like using emphasis for book titles and such.

## Punctuation

### Spacing
We use one space after full stops, not two. Sorry, twofers.
