# Markdown
This is a **Markdown syntax guide** which will attempt to establish conventions around how our Markdown looks. This page is exclusively for differences which are noticeable only in *unparsed* Markdown. For differences that affect how parsed Markdown looks, see the [Formatting](formatting.md) guide.

## Emphasis and strong
Use asterisks for strong and emphasis, not underscores. This is simply for the sake of convention; there are no practical reasons one is better than the other.

```markdown
<!-- bad -->
_emphasis_
__strong__

<!-- good -->
*emphasis*
**strong**
```

## Headings
Use the `/#{1,6} .+/` syntax for headings, not the underline syntax.

```markdown
<!-- bad: only two levels, hard to edit -->
First-level heading
===================

Second-level heading
--------------------

<!-- good: all six levels, easy to edit -->
# First-level heading
## Second-level heading
...
###### Sixth-level heading
```

## Links

Links to **other files** in this repo should use **inline link syntax**:

    Check out the [formatting page](formatting.md)!
    Also check out the [video section](/video/README.md)!

When linking to a folder, always link to the folder's README -- never to the folder itself.

Links to **other websites** or other repositories should use **numbered footnote links**:

    Also look at the [Twitch][1] [OAuth token authenticator][2]!

    [1]: https://www.twitch.tv/
    [2]: https://git.xarth.tv/web/owl

Footnotes in this style of syntax should go at the **bottom of the section**, not necessarily at the bottom of the
article. A section is defined as a group of text between headings (of any level).

Good:

    ## A heading!
    [This is][1] a link to Twitch

    [1]: https://www.twitch.tv/ # put this here

    ## Another heading!

    More text!

Bad:

    ## A heading!
    [This is][1] a link to Twitch

    ## Another heading!

    More text!

    [1]: https://www.twitch.tv/ # not here
