Engineering Metric Collection At Twitch
---

The engineering metric collection "stack" is managed by the Systems engineering team. See the
"#metrics" slack channel if you have more questions. For business metric related topics see [stats](https://git.xarth.tv/twitch/docs/tree/master/stats).

## Metric Processing

* The recommended approach for creating metrics is by pushing them to our [statsite](https://github.com/armon/statsite) collectors at `statsd.central.twitch.a2z.com:8125` via UDP. From here metrics are time-bucketed, accumulated, and sent to Graphite for storage. Metrics that are created this way are accessible at `Metrics.stats` by default within [Graphite](#storage).
* You can push metrics directly to [Graphite](https://graphite.readthedocs.org/en/latest/feeding-carbon.html#getting-your-data-into-graphite) by sending metrics to `graphite.internal.justin.tv:2003` via TCP

## Storage

We use [Graphite](http://graphite.internal.justin.tv/) as our metric storage layer. 

## Presentation/Viewing

The preferred presentation layer for viewing metrics and created dashboards is
via [Grafana](http://grafana.internal.justin.tv).

### Adding Your AWS Account's CloudWatch Metrics

Follow https://wiki.twitch.com/display/SYS/Grafana+-+Adding+New+Cloudwatch+Data+Source for to have your cloudwatch metrics added as a datasource.

## Related Projects

* https://git.xarth.tv/common/gometrics
* https://git.xarth.tv/common/ddbmetrics
* https://git.xarth.tv/systems/uptime
* https://git.xarth.tv/systems/plucker

