Open Source at Twitch
=====================

* [Mirror of Amazon Open Source Documentation](https://twitchtv.atlassian.net/wiki/display/ENG/Open+Source+Policies+and+Documentation)
* [Questions?](mailto:tarrant@twitch.tv)

FAQ
===

### How do I ask for permission to submit issues or code to public projects?

Please send an email with relevant details to the following addresses:

* opensource@twitch.tv

### How do I get permission for a side project?

Please send an email with relevant details to the following addresses:

* techprojectapproval@twitch.tv

### Can I use this AGPL Code?

No. There is currently one exemption for AGPL in all of AMZN and its children
companies. That exemption is for MongoDB at Twitch. It took a bunch of lawyers
and VPs to get that cleared. Realistically the chances of getting another AGPL
library cleared for use are slim.

### Can I use facebookgo libraries?

Maybe? The license included in many of the
[FacebookGo](https://github.com/facebook/go) repos is safe. The issue is that
the [patent grant](https://github.com/facebookgo/cmdctrl/blob/master/patents)
makes a binding agreement between all of Twitch, AMZN and its other
subsidiaries and Facebook. Currently we have not gotten the right VPs to
sign off on this. It may be possible to get this granted but it will not be
easy.

If the library does not contain the patent grant and is under an acceptable
license than go ahead, but keep an eye out for the patent grant being added
when you upgrade.

### What about External Contractors writing Open Source for us?

If there are external contractors who are using their own equipment, where the
only involvement we have is spec and money then treat it the same way you would
any other open source contribution. Mail the right people and ask for
permission.

### How do I do Attribution of Third Party Code?

If code from a third party is being done on behalf of Twitch attribution is not
always needed or wanted.

Twitch and Amazon only want attribution if the code is of a standard that meets
or exceeds code that Twitch or Amazon would produce themselves.

If attribution is desired it should be done on behalf of "Twitch".

### How can I contribute to amazon's open source projects?

There are discussions on changing the policy but currently you need to treat it
like any other public open source contribution. That is you should send an
email to opensource@twitch.tv.

Alternatively you can just send an email to the project manager internally and
treat it like a private conversation.
