# Rabbit

Open Source message queueing system.

Currently runs on rails-rabbitmq-[5cc4a8, 68bc38, 6db488].sfo01.justin.tv

## Useful command line methods:

    sudo rabbitmqadmin list queues vhost name node messages message_stats.publish_details.rate message_stats.deliver_details.rate

    sudo rabbitmqadmin -f long -d 3 list queues
  
Admin interface on port 15672, credentials are guest/guest.

## To open the web view:
* Open a ssh tunnel to one of the rabbit boxes
  * ssh rails-rabbitmq-68bc38.sfo01.justin.tv -L15672:localhost:15672
* Go to http://localhost:15672/
* Log in with guest/guest

## Useful Information
* Ensure all nodes are up
  * Go to 'Overview' tab
 
  ![Overview](images/overview.png)

  * Expand 'Nodes'
    * All nodes should show statistics (green)
    * If a node is down (red), please [restart](../web/on_call.md#how-to-start-the-rabbitmq-server-if-it-goes-down) it
 
  ![Nodes](images/nodes.png)

* Ensure jobs are being consumed
  * Go to 'Queues' tab
 
  ![Queues](images/queues.png)

  * Look at the status of each queue
    * The consumption (delivery / get) should be >0 assuming there are ready messages
    * State should be idle or running, not down
 
  ![Queue Columns](images/queue_columns.png)
  ![Good Queue](images/good_queue.png)
  ![Bad Queue](images/bad_queue.png)
