# MOLT Data Analysis

🔥This document is for MOLT firefighting! 🔥

It will contain:

1. List of unresolved Molt issues
2. To do list for resolving the Molt issues
3. Resolved Molt issues and their resolutions
3. All of the relevant Molt data reports in one place, in reverse chronological order

_Recent updates will be in bold_

#### Unresolved Molt issues:

1. % time buffering is up by ~35% 
2. minute_watched is down by 1-2%

#### To Do list to resolve these issues:

1. % time buffering problem:
  * Backported libhls: % time buffering in legacy went up and seems to match Molt
    * We are looking through the libhls changes to narrow down which commit cause the higher % time buffering
    * The broadcaster latency correlation leads us to believe it will be the timestamp code, but we are currently testing the buffering code
2. minute_watched problem:
  * We expect minute_watched is down as a result of the QOS issues with buffering. Will wait to resolve buffering issues, and then see if minute_watched goes back up.
  * offline/online detection is still sketchy in Molt, if you go back online, the whole player gets stuck in offline mode and could lower our overall minute_watched

#### Resolved Molt issues:
1. fewer ad impressions
  * Legacy player was not implementing pre-roll ratelimit properly. Pre-roll ads are not supposed to play for 5 minutes after a pre-roll has been watched. Legacy player was showing ads within the 5 minute range.
2. Firefox dropped frames:
  * Drew's [Firefox data](https://modeanalytics.com/twitch/reports/1f231e100d40/runs/5e0e02a2a931) shows that the number of Firefox users is very small. Most likely not the cause of our minute_watched decrease. We are inclined to not address the Firefox issues.
    * D comment: My argument re: firefox is not that we shouldn't fix it - it's objectively poor behavior. It's that it's not hitting minutes watched per device in a major way that would explain our global problem. But living with that quality of video experience is not something we should view as a not-fix resolution IMO.  

#### Molt Data Reports
(In reverse chronological order)
* [Added broadcaster_latency to data report](https://modeanalytics.com/editor/twitch/reports/b9bb20754d81/runs/1b99b155096e)
  * Molt was 500-600ms lower latency
  * This likely could have been the cause for % time buffering to go up
  * This leads us to believe that the code change in libhls around timestamps will be the culprit

* [seconds_offset distribution looks non-crazy](https://modeanalytics.com/editor/twitch/reports/16f2cafcec3e/runs/5b473fea9438) - Drew
  * our operating assumption is that the roll 0-60 is perfectly flat, and that the deviation from that is a result of people who roll higher numbers churning out before they fire a single event with that seconds_offset value. that seems like an okay assumption here. If entropy on that was broken in some significant way, I think we’d see clumping of somekind not this monotonic decay
  * that said, there IS a meaningful difference between in the lengths of sessions; it looks like molt does have legit shorter sessions in the sub 60 second range. I'm not sure this could add up to cover the whole issue, but it could conceivably be part of molts' problems.
* [post ad minutes per session](https://modeanalytics.com/editor/twitch/reports/08a261f5a05a/runs/565b61fcac48) - the theory is that something breaks after ads run that causes dropoff in the minutes immediately following an ad.
  * some evidence to support this one too - there are more shorter sessions and fewer longer sessions (when viewed as the 15 minutes after completing a midroll or preroll ad) on molt.
  * That said, combined with the evidence above about seconds_offset, we could be mis-attributing here. If molt sessions are just across the board shorter (which pretty much needs to be true for minutes-watched to be down) we would find this pattern any way we sliced it. So although this bug definitely seems to exist and should be fixed, my confidence is relatively low that it accounts for the whole thing. But if the problem is actually a few smaller issues (which is totally possible) this should be on the list.
* [Performance checking for Firefox](https://modeanalytics.com/twitch/reports/1f231e100d40/runs/5e0e02a2a931), by Drew
  * **Basically the same minute_watched decrease**
  * **Very small user group, most likely Firefox dropped frames are not the cause for overall minute_watched decrease**
  * **Weirdly buffer-empties and buffer-refills are lower, maybe a minor decrease in % time buffering, but the minutes decrease is about the same.**

* [turbo users vs non-turbo](https://modeanalytics.com/editor/twitch/reports/7224eb6a5c84/runs/9e68d22c6647), by Josh
  * **Unexpectedly, turbo users show a LARGER difference between control and experiment** 
  * **There is a 6-8% MW decrease in experiment, and 35-50% more buffering**
  * **Total user pool ~20k people, control vs experiment ratios are correct**
  * **Why is refills per empty at >3???**

* [Drew and Brad’s updated & accurate queries for performance checking:] (https://modeanalytics.com/editor/twitch/reports/039df941e2c4/runs/387c35343bec) Includes:
  * distinct devices per day
  * average minutes per device
  * average empties
  * average refills
  * % time buffering
  * minutes_buffering
  * refills per empty
  * we also have the same metrics above, but with a quality filter, so you can see the stats for each quality level:
  * https://modeanalytics.com/editor/twitch/reports/8008d12e7442/runs/74a083ebe4bf

* [Buffer empties after a video play, Molt vs Legacy] (https://modeanalytics.com/editor/twitch/reports/017151404de6/runs/49266a416877)

* [Video ad request declined by experiment group with reason](https://modeanalytics.com/twitch/reports/7dcc70cd1ba1/runs/078303d8c467), by Scott
  * This report helped us catch the inconsistency between MOLT and legacy for preroll ads declined due to “reason_ratelimit”. It turned out that the legacy player was not declining ads for reason_ratelimit when it should have been. MOLT was behaving correctly (not playing prerolls, which led to a decrease in ad_impressions on MOLT.

* Ratio of video_ad_request_declined and video_ad_request, MOLT vs legacy
  * [video_ad_request_declined](https://modeanalytics.com/twitch/reports/f700b185dbb4/runs/343b184746e1)
  * [video_ad_request](https://modeanalytics.com/twitch/reports/c7101a4b8759/runs/d4299e0674c6)
  * This data shows that the MOLT vs legacy ratios are at the expected percentages for our experiment groups: 70% control, 20% MOLT, and 10% not counted. 
    * 20/90 = 22% MOLT
    * 70/90 = 78% legacy

* [Relevant MOLT reports in Mode](https://modeanalytics.com/twitch/lists/efb714063fce), by Brad
  * minute_watched -- player = “site” and live
  * buffer empties
  * subscription flow starts
  * time spent buffering
  * new followers per device
  * video ad impression
    * This graph shows that fewer ad impressions were occurring in MOLT compared to legacy
  * video ad request
    * This graph shows that fewer ads were being requested by MOLT than legacy
  * seconds_offset
  * video_ad_request_declined (with reason)
  * time spent buffering MOLT vs Legacy for specific quality

* [Product Events Tracking](http://docs.sci.twitch.tv/events/index.html), by Drew Harry
  * This spec covers the Tier 1, 2, 3 events to ensure are working properly when releasing new versions of the player

* [QA Test Plan for MOLT](https://docs.google.com/document/d/1Vzjw80ubfWdiaTUPGz9l1WXIOddSEp0VVA32Adp0j_M/edit), by Vikram

* [Video_init to video_play](https://modeanalytics.com/twitch/reports/9b97792b20fa/runs/533e4f1c8945)
  * This was a quick sanity check to see how many users are making it from vidio_inits to video_plays in the new player
  * A lower percentage of people were making it from video-inits to video-plays in MOLT: ~98% in Flash, 78% in Molt
  * The change in ratios of video-plays to video_inits can be explained by sending "video_init" on offline channel views.
  * We weren’t sure why the group sizes were different

* [MOLT experiments spec](https://docs.google.com/document/d/1WwmOmY_cLVta8ZHvXnxr0tApUYGoC-c-0yeefrfhunE/edit)
  * This document details the original MOLT experiment breakdown, the metrics to track, and the expected outcomes/goals.

