# Pubsub

[Quick Start Guide](https://docs.google.com/document/d/1_Q59Hth20NP4jXvSUo29E3h3xS9BhwiSWOojBWjR-9o/edit?usp=sharing)

### What is this system?
This document describes a system which allows backend services to broadcast targeted realtime messages to clients.  Example usages include:

* An instant messaging system broadcasting an instant message to an individual user's live sessions
* A backend service sending a stream title update to all users who are watching a particular channel
* A presence system broadcasting a user's online status to all their friends

This system approximates a smaller-scoped but more scalable and versatile version of TMI's message-passing architecture, which we have a lot of experience with scaling, hardening, and monitoring.

### Components

[Pubsub Edge](https://git.xarth.tv/twitch/docs/blob/master/pubsub/pubsub-edge.md)

[Pubsub Broker](https://git.xarth.tv/twitch/docs/blob/master/pubsub/pubsub-broker.md)

[Pubsub Control](https://git.xarth.tv/chat/pubsub-control/blob/master/README.md)


### Architecture

* This system implements an **at-most once, best-effort, pubsub** push mechanism. 
    * Message delivery is not guaranteed - if a system uses Pubsub and wants to guarantee delivery they will need to implement their own retry/acknowledge logic.
* There's initially no clustering, which reduces administrative and operational complexity - all edges/brokers are configured identically
* Internal ELB between backend services and brokers
* External ELB for clients to connect through to edges
    * Also performs SSL termination
    * Uses PROXY (http://docs.aws.amazon.com/ElasticLoadBalancing/latest/DeveloperGuide/enable-proxy-protocol.html) protocol: 
