# Pubsub-Broker

Backend services submit HTTP POST requests to a broker (via internal ELB in a round-robin configuration) for message distribution

##### POST /v1/message
```
{
  'topics': ['topic1', 'topic2', ... 'topicn'],
  'data': 'arbitrary string'
}
```
* **topics** is an array of up to 1000 strings
* **data** is an arbitrary string. Presumably, backend services will use json here, and the clients on the other end will know to unmarshal the **data** field into an appropriate struct. However, PubSub does not enforce or care about what protocol is used between the backend services and their clients.
* Backend services can broadcast a message set to a **group** of topics
* Broker's message to Edges includes the full **data** field, and a **topics** field that is filtered to only topics that each particular edge cares about
* Returns a response to the backend service immediately - hands off responsibility to a goroutine
  * Returns 200 and passes the message off if the body was of the correct format
  * Returns 400 if the body was not of the correct format
  * This means the calling service can't be **sure** the message goes through the whole pipeline successfully - applications must handle this themselves

