# Pubsub-Edge

An **edge** is a server which clients directly connect to for subscribing to topics and receiving messages

### Client <=> Edge API

Clients establish a secure, persistent, bi-directional connection to an edge via websockets. All messages are single-crlf-delimited in both directions (these characters are escaped in messages sent over the wire).  There are still some details to be worked out here as to wire-protocol specifics.

* Client connects to edge
  * Timeout and disconnect if the client doesn't subscribe to any topics within **20 seconds**
  * Rate-limiting (id, ip, etc) TBD
* Client disconnects from edge
  * Edge emulates **unlisten** messages for topics this client listens on

#### Message Format

All messages between clients and edges are JSON messages of the form:
```
{
  "type": t,
  "data": d, // data blob, JSON format depending on the type of message
}
```

#### Client => Edge Messages

* Note that below the **nonce** is used by a specific client to know the results of commands it sends to the edge, so it should simply be unique to that client/connection.

##### Listen

```
// Request
{
  "type": "LISTEN",
  "nonce": n, // string to be used as a request id
  "data": {
    "topics": [t1,t2,...],
    "auth_token": at, // could be empty
  }
}
// Response
{
  "type": "RESPONSE",
  "nonce": n, // matches the request nonce
  "error": e, //empty if no error, otherwise one of ERR_BADMESSAGE, ERR_BADAUTH, ERR_SERVER, ERR_BADTOPIC
}
```
* Limit each client to a **maximum of 10 topics** for now (RIP bots)
* Also limit client listen/unlisten churn
* We only need to authenticate/authorize for some types of topics (user-specific) - use owl
  * later use cartman?

##### Unlisten
```
// Request
{
  "type": 'UNLISTEN',
  "nonce": n, // string to be used as a request id
  "data": {
    "topics": [t1,t2,...],
  }
}
// Response
{
  "type": 'RESPONSE',
  "nonce": n, // matches the request nonce
  "error": e,  //empty if no error, otherwise one of ERR_BADMESSAGE, ERR_SERVER, ERR_BADTOPIC
}
```
* Useful for persisting the user's connection while navigating through different channels
* Issue **unlisten **message for this topic to brokers if this edge has no more listeners on this topic

##### Ping
```
// Request
{
  'type': 'PING',
  'data': nil,
}
// Response will come as a PONG
```
* For application-level keepalives - clients should send every jittered 5 minutes (see below)
* If an edge has not received a **ping** message in the last 10 minutes, disconnect the client

#### Edge => Client Messages

##### Message
```
{
  "type": "MESSAGE",
  "data": {
    "topic": t,
    "message": d, // data blob
  }
}
```
* A new message must be sent to the client on the specified topic

##### Pong
```
{
  "type": "PONG",
  "data" nil,
}
```
* For application-level keepalives - sent in response to a **ping** message
* If a client does not receive a **pong** within 5 seconds of sending its **ping**, the client should reconnect after a jittered 1 second duration

##### Reconnect
```
{
  "type": "RECONNECT",
  "data": nil,
}
```
* The edge server is restarting gracefully, the client should reconnect within 15s or it will be disconnected by the edge.


#### Caveats
* If a client has more than _20 unreceived messages_ pending for them on the edge the connection will be dropped and the client must reconnect - solves the “slow reader” problem
* **NOTE**: If a client becomes disconnected from an edge, it is up to the product leveraging Pubsub to recover.  For instance, if a client's edge connection is broken, the client-side presence code must fetch the current state of the world from the presence server to get the most up-to-date state.
* Edge restarts - edges will gradually drain client connections, allowing clients to slowly reconnect to new edge servers
