# Release

### [I want to deploy my master branch to production](deploy.md)

Our new workflow promotes merging changes into the master branch before shipping code to production. This works well when you want to perform code reviews via pull requests (or phabricator) before deploying. Branches tend to be shorter-lived and merged more frequently.

## Overview of tools used with the deploy pipeline
- **(Optional) [Terraform](https://git.xarth.tv/twitch/docs/blob/master/aws/terraform.md)**: This is used to manage AWS EC2 instances if you're going that route.
- **[Manta](manta.md)**: Wraps your build/test process in a container for isolation and reproducibility. Use it to create files to be deployed.
- **Vagrant**: Easy way to run Linux on your desktop. Allows you to develop with Manta locally.
- **Jenkins**: Runs build and deploy jobs, which you define. Commonly executes builds via Manta.
- **Capistrano**: Defines process for uploading files to production servers and restarting processes. Called from within a Jenkins deploy job.
- **[Courier](https://git.xarth.tv/release/courier)**: Upcoming internal tool to distribute application binaries to servers.
- **[Puppet](puppet-consul.md)**: Used to define how to run your application on production servers.
- **[Consul](puppet-consul.md)**: Service discovery system used to query which hosts your application should be running on.
- **[Deploy](deploy.md)**: New deploy UI, used to trigger deployments of single branches to an environment.

# Bugs and Issues

For non-code related tasks and issues please file it in the [Roadmap Repo] (https://git.xarth.tv/release/roadmap/issues). For everything else file it as a Github Issue under the specific project.


# Links

Bringing up a new service:

* [Bringing up a new service](https://git.xarth.tv/twitch/docs/tree/master/siteinfra/new_service/shipping_a_new_app.md)

Links to useful things:

* [Phabricator](https://phabricator.internal.justin.tv)
* [Jenkins Web UI](http://jenkins.internal.twitch.tv/)
* [Consul Web UI](http://consul.internal.justin.tv/)
* [Deploy Tool](http://deploy.internal.justin.tv)
* [Scaffolding CLI Tool developed by Systems Engineering](https://git.xarth.tv/systems/scaffold)
