# Provisioning clean infrastructure

## Audit and move code to git-aws

After pushing to the new git repository, ask a github admin in #devtools to disable your dirty repository.

## Integrate with new deploy pipeline

If your project is already using the new deploy application, you can skip this section.

If your project was deployed via brigade, you will need to integrate the build and deploy process of your project with our new tools. Refer to the [migration documentation](deploy.md) for step-by-step instructions.

### Use courier for deploys

The new application validation system integrates with our courier deploy tools.  If you are using capistrano/fabric or some other custom means of distributing and restarting your application, you will need to convert that to courier. Our [migration documentation](deploy.md) details the steps needed.

## Define new consul environment

The new deploy pipeline can only distribute applications to clean infrastructure, so you will need to define a new deploy environment.  In the puppet manifests for your project, find calls to ```consul::service``` and design a way to use a different environment name for clean machines.

Assuming you previously were using a variable called ```$env``` with value of "production" in your puppet logic, you can use something similar to the following to have clean boxes run your app using the environment "clean-production".

```puppet
$deploy_env = hiera('clean', 'false') ? {
  'true'  => "clean-${env}",
  default => $env,
}

consul::service { "my_service":
  port        => 80,
  consul_tags => [$deploy_env],
}
```

## Remove dirty environments from deploy.json

If you were previously using the new deploy pipeline, you already have a file called ```deploy.json``` in the root of your repository. You need to remove any reference to dirty environments, only leaving the new environment(s) you defined in the previous section.  Deploys to dirty environments will fail anyway, so don't confuse your team by leaving them in.

## Use new UI to trigger deploys

Our new deploy application lives at [https://clean-deploy.internal.justin.tv](https://clean-deploy.internal.justin.tv/#/home).  Login using github and navigate to your project.

## Looking up Hosts

If you wish to test what hosts will be included in a deploy you can use the [consul-search](https://git.xarth.tv/common/consul-search) command line tool to test. It uses the same underlying apis as deploy and skadi.

```
consul-search --services=usher-video -tag=clean-production
```
