Consul is a distributed kv and service directory.

General Architecture
--------------------

Consul is a highly-distributed service discovery, locking and kv database.

The Consul system is built using two sets of distributed protocols. The first
is SERF which is a flat structured peering group for monitoring and message
passing. Second is RAFT a more centralized consensus algorithm for storing
information.

Along with two sets of protocols we have two classes of consul agents. Servers
and Clients.

Consul Servers are members of the RAFT cluster. They suffer from
higher load as they have extra responsibility. Consul Servers also do
everything that a Consul Client does.

The Consul Client has three roles. First it is responsible for responding to
SERF messages. This lets the rest of the cluster know that the box is still
alive. Basically it is a heartbeat. Second the Consul client will accept local
HTTP or DNS api requests and convert them to more sturdy RPC calls. This means
you can do things like make a long poll HTTP request to the local host and let the
underlying RPC worry about the connection being killed from underneath you.
Third the Consul Client is responsible for maintaining information about the
node. Any time there is disagreement about a node's information in RAFT or
SERF the node's beliefs get priority.

Configuring Consul Services
---------------------------

```puppet
consul::service { "puppet resource name":
  service_name   => "defaults to the puppet resource name",
  consul_tags    => ["production"],
  port           => 1935,
  check_script   => "/command/line/script -to -run",
  # Check_interval must be in go duration format: 1s == 1 second,
  # 5m  == 5 minutes
  check_interval => "5s",
}
```

Deploying New Consul Versions
-----------------------------

Checkout the consul-manta project. Consul manta uses manta to build godep saved code.

Update the deb version in `./deb/DEBIAN/control`.

Update the consul version on your computer and run `godep update <something????` (I'm not 100% sure of the right command).

Push your changes to git and deploy using clean-deploy.

Now deploy to servers:

```shell
# Deploy to a random 100 servers:
pdsh -w $(lsconsul -dc sfo01 -x -r | head -n 100 | tr '\n' ',') \
  'sudo puppet agent --test --tags=apt,consul'
# Deploy to all servers:
pdsh -w $(lsconsul -r) 'sudo puppet agent --test --tags=apt,consul'
```

We use the randomize feature, `-r`, from lsconsul because it helps prevent any
impact by upgrading too many consul servers in the same pop at the same time.

Adding Servers
--------------

Check the leader:

```shell
curl -s localhost:8500/v1/status/leader | grep 10\. | cut -d\" -f2 | cut -d: -f1 | xargs -I{} sh -c 'echo {}: `dig +short -x {}`'
```

Check the peers:

```shell
curl -s localhost:8500/v1/status/peers | python -m json.tool | grep 10\. | cut -d\" -f2 | cut -d: -f1 | xargs -I{} sh -c 'echo {}: `dig +short -x {}`' | column -t
```

Removing Servers
----------------

```shell
# Remove consul from being respawned by init:
sudo stop consul
sudo -u nobody /usr/bin/consul agent -config-dir /etc/consul.d
# In another shell run:
consul leave

# Verify that the node is no longer listed:
curl -s localhost:8500/v1/status/peers | python -m json.tool | grep 10\. | cut -d\" -f2 | cut -d: -f1 | xargs -I{} sh -c 'echo {}: `dig +short -x {}`' | column -t

# If it is still listed wait a few seconds or retry the process.
```

Once it is removed on the box update the hiera files in puppet to no longer
include the host in the join list.

If the box is no longer reachable you can use the force-leave api:


```shell
# From the same pop:
curl localhost:8500/v1/agent/force-leave/<node>

# Verify that the node is no longer listed:
curl -s localhost:8500/v1/status/peers | python -m json.tool | grep 10\. | cut -d\" -f2 | cut -d: -f1 | xargs -I{} sh -c 'echo {}: `dig +short -x {}`' | column -t
```

Changing a Server's IP
----------------------

Due to a bug in consul 0.4 (and possibly 0.5 we will see) changing the IP causes it to act as if a server disappeared and a new server joined. This means that you end up with extra servers in your peer list.

The easiest way is to fully remove the server from the cluster and then add it as a new server.

If you are past that you can temporarily change the advertise IP to the old ip, start consul, do a `consul leave` and then return it to its normal state.

Demoting Servers
----------------

Go through the process of removing a server. Make sure that the server no
longer appears in the peer list. Then update hiera to no longer include the
server in the join list.

It is **very important** when demoting a server to make sure it is no longer
listed as a peer before it reconnects as a client.

Adding a new Cluster
--------------------

With the new expect bootstrap system configuring consul clusters is as easy as
pie.

Update the hiera file for the pop to include something along the following
lines:

```yaml
---
consul::enable: true
consul::join:
  - server1.pop.justin.tv
  - server2.pop.justin.tv
  - server3.pop.justin.tv
  - server4.pop.justin.tv
  - server5.pop.justin.tv
```

From this puppet and consul will realize that you are planning to have a five
node cluster and will only initiate the system once all five of the
nodes have established a cluster. As is expected these numbers will change
depending upon what your `consul::join` list looks like.

Once the cluster is established you should verify that the cluster is running
and can communicate with other pops:

```shell
# Check if consul is running:
vagrant@precise:~$ consul members
Node     Address             Status  Type    Build  Protocol
precise  172.16.66.140:8301  alive   server  0.3.1  2

# Check that consul has established a leader:
vagrant@precise:~$ curl localhost:8500/v1/status/leader; echo
"172.16.66.140:8300"

# Check that all consul raft servers are listed in the peers:
vagrant@precise:~$ curl localhost:8500/v1/status/peers; echo
["172.16.66.140:8300"]

# Check that consul joined the wan, to be safe this needs to be run on every
# consul raft server:
tarrant@consul1:~$ consul members -wan
Node           Address              Status  Type    Build  Protocol
video33.ams01  185.42.204.100:8302  alive   server  0.3.1  2
video3.lhr01   185.42.204.6:8302    alive   server  0.3.1  2
video9.iad02   192.16.70.13:8302    alive   server  0.3.1  2
...
```

Debugging
---------

Logs can be found in `/var/log/jtv/consul.log`. On upstart boxes you can also
find additional logs in `/var/log/upstart/consul.log`.

If you get stuck you can contact Armon Dadgar, <armon@hashicorp.com>, for more
assistance.

Check if Consul Leader is Elected
=================================

```shell
curl localhost:8500/v1/status/leader
```

Forcing a Single Server to come Online
======================================

= If the entire cluster is having trouble staying online and you wish to force
a single node to take over you can do it with a bit of manual munging.

1. Stop all of the consul servers in the datacenter.

    ```shell
    sudo stop consul
    ```

2. Empty the peer list. This will stop the new leader to not fail quorum
   elections due to not being able to contact the other servers.

    ```shell
    echo '[]' | sudo tee /var/lib/consul/raft/peers.json 
    ```

3. Remove `"boostrap_expect": <number>` and replace it with `"bootstrap":
   true` in the `/etc/consul.d/main.json` config file.

   This will force it to not wait for other members to come online for a quorum
   and tell the node that it should assume that it is the leader.

4. Start consul on the chosen server.

    ```shell
    sudo start consul
    ```

You now have a single node running your cluster. You should not leave consul
in this state any longer then you have to. It will likely lead to data loss
over the long term and loses many of the benefits of a distributed datastore.

Force one Node's data as Canonical
==================================

If consul gets into a state where all of the servers disagree with each other
about what the raft data log should look like then you can force one node to
win.

1. Chose a server to be correct.

2. Stop all of the consul servers in the data center.

    ```shell
    sudo stop consul
    ```

3. On all of the non-chosen nodes delete their data:

    **Warning: make sure you don't do this on your chosen node!!!**


    ```shell
    sudo mv /var/lib/consul/raft/ /tmp/raft-backup-`time +%s`
    ```

4. Start all the consul servers:
    
    ```shell
    sudo start consul
    ```
    
5. Check the logs and ensure the other servers are syncing with the chosen
   server.
