#!/usr/bin/env bash

# Handles parsing git tag information out and then calling manta with the information
# injected so that it can be used when naming the dpkg artifact.

PACKAGE_NAME="<your-package>"

ARCH=amd64
LATEST_TAG=$(git describe --abbrev=0 --tags)
TAGVER=$(echo $LATEST_TAG | sed -e 's/[v\.]*\(.*\)/\1/')
PACKAGE_VER="${TAGVER}-$(echo $(wc -l <(git log --oneline ${LATEST_TAG}..HEAD)) | cut -f1 -d ' ')"

DEB_NAME="${PACKAGE_NAME}_${PACKAGE_VER}_${ARCH}.deb"

sed "s/DEB_FILE_PLACEHOLDER/${DEB_NAME}/g" .manta.json.tmpl > .manta.json

manta -v -e DEB_NAME=$DEB_NAME -e PACKAGE_VER=$PACKAGE_VER -e ARCH=$ARCH -e PACKAGE_NAME=$PACKAGE_NAME

rm .manta.json
