job {
	name '<team>-<service>-build'
	using 'TEMPLATE-autobuild'
	scm {
		git {
			remote {
				github '<repo>', 'ssh', 'git-aws.internal.justin.tv'
				credentials 'git-aws-read-key'
			}
		}
	}
	steps {
		shell 'rm -rf .manta/'
		shell './build_script.sh'
		saveDeployArtifact '<repo>', '.manta'
	}
}

job {
    name '<team>-<service>-aptly'
    parameters {
      stringParam 'GIT_COMMIT'
    }
    steps {
      downloadDeployArtifact '<repo>'
      uploadDeb '<dpkg-name>'
    }
    wrappers {
      preBuildCleanup()
      timestamps()
      credentialsBinding {
	file('AWS_CONFIG_FILE', 'aws_config')
      }
    }
}
