#!/usr/bin/env bash

# manta_deb.sh: called from within manta. Uses the built bin file to
# create a dpkg. Uploading to aptly is handled separately via clean-deploy
# in a separate step

set -e

if [ -z $DEB_NAME ]; then
    echo "DEB_NAME environment variable not set, bailing"
    exit 1
fi

if [ -z $PACKAGE_NAME ]; then
    echo "PACKAGE_NAME environment variable not set, bailing"
    exit 1
fi

if [ -z $PACKAGE_VER ]; then
    echo "PACKAGE_VER environment variable not set, bailing"
    exit 1
fi

if [ -z $ARCH ]; then
    echo "ARCH environment variable not set, bailing"
    exit 1
fi

BIN_NAME="<YOUR_SERVICE>.bin"

PACKAGE_ROOT=$(mktemp -d -t package_XXXX)

# monit
MONIT_DIR="etc/monit/conf.d"
MONIT_FILE="${MONIT_DIR}/${PACKAGE_NAME}"

mkdir -p "${PACKAGE_ROOT}/usr/bin/"
mkdir -p "${PACKAGE_ROOT}/${MONIT_DIR}"

# copy our binary into the pkg
cp -a $BIN_NAME "${PACKAGE_ROOT}/usr/bin/${PACKAGE_NAME}"

# copy our monit config into the pkg
cp -a monit_conf "${PACKAGE_ROOT}/${MONIT_FILE}"

echo "Building dpkg"

# bundle our dpkg up, PACKAGE_VER is inject into manta from the jenkings.groovy job
fpm -s dir -t deb -a "${ARCH}" -n "${PACKAGE_NAME}" -d 'monit' --config-files "${MONIT_FILE}" -v $PACKAGE_VER -p $DEB_NAME -C $PACKAGE_ROOT

echo "Dpkg Artifact Created: ${PACKAGE_NAME}"
