How Do I Automate Debian Package Management?
---

For various reasons you might want to build, manage, host, and deploy a [Debian package](https://www.debian.org/distrib/packages)
to your systems or services. These processes can be automated using existing Twitch build tools.


## 1. [Create A Software Application](https://git.xarth.tv/twitch/docs/blob/master/release/deploy.md#application-deployment-process)

Note: Using the above tutorial, you WILL need to setup a build step, but WILL NOT need to add a deploy job since that will be covered below
in a manner specific to dpkgs.

## 2. Publishing To Aptly

We maintain our own internal Aptly server at `aptly.internal.justin.tv` to publish your newly built package to this server for installation
via `apt-get install`, add the following job to your project's jenkins.groovy file:
```
job {
    name '<team>-<service>-aptly'
    parameters {
      stringParam 'GIT_COMMIT'
    }
    steps {
      downloadDeployArtifact '<team>/<service>'
      uploadDeb 'sandstorm-agent'
      uploadDirtyDeb 'sandstorm-agent'
    }
    wrappers {
      preBuildCleanup()
      timestamps()
      credentialsBinding {
	file('AWS_CONFIG_FILE', 'aws_config')
      }
    }
}
```

In order to trigger this job via the [deploy tool](clean-deploy.internal.justin.tv), add the job to the environments portion
of your [deploy.json](https://git.xarth.tv/twitch/docs/blob/master/release/deploy.md#5-configure-deploy-details-in-your-repository) file:
```json
"environments": {
  "aptly": {
    "job": "<name-as-specified-for-jenkins.groovy"
  },
},
```

## 3. Install Your Apt Package With Puppet:

First, see our [getting started with puppet](https://git.xarth.tv/systems/puppet#getting-started) guide. 
Automating the installation of your service with puppet is quite simple:
```puppet
package {'<your-dpkg-name>':
  ensure => latest,
}
```

## Finished!

You should now be able to automatically build dpkg artifacts when new changes are pushed to your master branch, you should be able to publish
that package to aptly, and your services should automatically install and retrieve the latest version when puppet is ran.
