# Deploy

Using this tool, you can see a list of all the branches in your repository.  An icon next to each branch will note whether the tip of the branch is building successfully. (i.e. tests are passing) You select a branch which has a successful status, and then choose a target environment to deploy it to.  We begin deploying your branch to that environment using the config options you choose.  Progress of the deploy can be seen below, as well as the history of previous deploys for each environment.

![deploy](images/deploy.png)

If you're looking for the runbook, you can find it [here](https://git.xarth.tv/dta/skadi/blob/master/doc/runbook.md)

# Contents

1. [App Deployment](#application-deployment-process)
2. [Debian Package Deployment](#debian-package-deployment-process)
3. [FAQ](#faq)

# How do I access the web UI?

## [clean-deploy.internal.justin.tv](https://clean-deploy.internal.justin.tv/)

# Mental model for deployment

There are four steps to getting code into production:

 1. Define the hosts that make up 'production'
 2. Turn your code into a deployable 'build artifact'
 3. Ship the build artifact onto the production hosts
 4. Run any scripts to kick off your freshly-baked production code

We have tools for each of these:

| step              |             tool |       what you do |
|-------------------|------------------|-------------------|
| define production | consul, puppet   | [Register servers in Consul via Puppet](puppet-consul.md) |
| build code        | jenkins, manta   | [write .manta.json](manta.md), [define build job](#2-define-build-job-in-jenkins)   |
| ship artifact     | jenkins, courier | [define deploy job](#3-define-deploy-job-in-jenkins), [write deploy.json](#5-configure-deploy-details-in-your-repository) |
| run postdeploy    | courier          | [write courier/restart.sh](#7-create-courier-restart-script-and-include-it-in-your-build-artifact) |


# Application Deployment Process

## 1. [Integrate manta](manta.md)

## 2. Define build job in Jenkins

This workflow assumes that every commit on every branch of your project is being built and made ready for deployment, and that you will create a single Jenkins job to handle this. The build process for your app must be "portable", meaning that it can be built once and deployed to any environment.  Follow the [jenkins-jobs documentation](https://git.xarth.tv/release/jenkins-jobs#build-jobs) to create your job. (Using the `TEMPLATE-autobuild` template is recommended). N.B.: If this is the first time adding a jenkins.groovy file to your repo you need to commit it to the master branch of your repo for Jenkins to create the job.

Example `jenkins.groovy` file:

```groovy
job {
	name "web-jax"
	using 'TEMPLATE-autobuild'
	scm {
		git {
			remote {
				github 'web/jax', 'ssh', 'git.xarth.tv'
				credentials 'git-aws-read-key'
			}
			clean true
		}
	}
	steps {
		shell 'manta -v'
		saveDeployArtifact 'web/jax', '.manta'
	}
}
```

At this point, it is recommended to make a commit on a branch in your repo and confirm that the build job runs and succeeds before continuing. Note: You may need to trigger the build manually for the first time, you can do this by going to the jenkins job view and clicking "Build Now".

## 3. Define deploy job in Jenkins

Your deploy job should call [courier](https://git.xarth.tv/release/courier) to do the heavy lifting of your
deploy. Details about the syntax for deploy jobs can be found in the
[jenkins-jobs readme][jenkins_jobs_readme]

[courier]: https://git.xarth.tv/release/courier
[jenkins_jobs_readme]: https://git.xarth.tv/release/jenkins-jobs#deploy-jobs

Example:

```groovy
job {
	name 'web-jax-deploy'
	using 'TEMPLATE-deploy-aws'
	steps {
		shell 'courier deploy --repo web/jax --dir /opt/twitch/jax'
	}
}
```
## 4. [Add Puppet configuration and register Consul](puppet-consul.md)
N.B. There is a chance that Courier will fail to install because Consul is missing an initial commit in Key-Value. You'll want to add a commit hash to here in order to get it installed: `http://consul.internal.justin.tv/ui/dist/#/{data center, e.g. us-west2}/kv/deployed-version/{git_org}/{repo-name}/clean-production/edit`.

## 5. Configure deploy details in your repository

Create a file named `deploy.json` in the root directory of your repository. See the [deploy.json documentation](https://git.xarth.tv/dta/skadi/blob/master/doc/repo_conf.md) for details on schema and field usage.

## 6. Deploy using docker containers - example
```json
{
  "job":"devtools-phabricator-deploy",
  "consul_services":[
    "phabricator"
  ],
  "environments":{
    "development":{},
    "production":{}
  },
  "artifact":"docker",
  "docker": {
    "image":"docker.internal.justin.tv/devtools/phabricator",
    "flags":"-p 80:80 -v /repos:/home/phabricator/repos"
  },
  "distribution": {
    "style": "fast"
  },
    "restart": {
    "style": "fast"
  }
}
```
Required Fields:
* docker
  * image - this is the image that you want to use for your application. A git commit hash will be placed on the end.
  * flags - these are flags required to run your application. And are passed directly to the `docker run` command.

Within your Jenkins Job:
* Courier Deploy - using courier as the deployment frame work requires a command similar to this:
`courier deploy --hosts $HOSTS --environment $ENVIRONMENT --repo "dta/devtools_phabricator" --image "docker.internal.justin.tv/devtools/phabricator"` 
  * --hosts - the hosts that will receive the courier deployment
  * --environment - this is the environment name you've chosen, it can be anything, but generally production, development, etc ...
  * --repo - The repo that hosts the code you're trying to deploy.
  * --image - The image name you wish to deploy. Note that a :<git hash> will be appended to the end for deployment.

Within your jenkins.groovy file
* In the build job
  * using 'TEMPLATE-autobuild'
* In the deploy job
  * using 'TEMPLATE-deploy-aws'

In Consul:

Make sure your consul configuration in /etc/consul.d has the following:

service_nodeinfo.json
```json
{"service":{"check":{},"id":"nodeinfo","name":"nodeinfo","port":0,"tags":["fqdn=ip-10-194-132-196.us-west-2.compute.internal","lsbdistcodename=precise"]}}
```
  * The FQDN here is important to Skadi

service.json
```json 
{"service":{"check":{},"id":"phabricator","name":"phabricator","port":80,"tags":["development"]}}
```
  * This line shows the name, and tags that will be used by Skadi to determine what node to deploy to.

## 7. Create courier scripts and include them in your build artifact

### Post-install

If you want to execute project-specific logic after your tar artifact is extracted, create a `courier/post-install.sh` file. `$ENVIRONMENT` will be available to your script.

### Restart

For deployments of simple tar archives, courier does not know how to start your application. (Courier can restart docker containers automatically).  By creating a `courier/restart.sh` in your build artifact, courier will execute this after a successful installation.  If your script exits 0, courier will treat the application as started.

Example used in conjunction with [daemontools](https://git.xarth.tv/twitch/docs/blob/master/release/puppet-consul.md#daemonupstartbasic-logging-configuration):

```bash
#!/usr/bin/env bash
set -e -x

sudo svc -t /etc/service/jax
```

**Important:** If you specify a restart.service key in your deploy.json, Courier will **NOT** attempt to run `courier/restart.sh` and will instead try to restart the a matching daemontools managed service.

# Debian Package Deployment Process

If you're interested in trying to use this process for dpkg's see [this guide](https://git.xarth.tv/twitch/docs/blob/master/release/debpkg.md).

# Deploy UI

- [How to use Snapshots](deploy/snapshots.md)

# FAQ

### How do I test changes to my `jenkins.groovy` build?

Our build system picks up changes to `jenkins.groovy` only when
they are merged to master. If you want to test changes without
merging to master, you can create a new repository in GitHub
containing your build.

1. Create a new (non-fork) repository containing your `jenkins.groovy`.
2. Change the job names to something unique e.g. `mukund-web-build`
3. Change the repo names (ala `web/web-client`) to point at your own repo
4. [Add the devtools user as a collaborator][add_collaborator] to your repository.
5. Push your jenkins.groovy change to the master branch of your repository.  
    **NOTE**: It's a good idea to [test your jenkins.groovy changes][test-changes] **before** pushing them to your master branch. If you push jenkins.groovy changes to your master branch and it has errors, the [`job-dsl-seed`][job_dsl_seed] automation will ignore your file.
6. Visit [`job-dsl-seed`][job_dsl_seed] page and you should see a new build that was triggered by your jenkins.groovy push to master.
7. Visit [the Jenkins dashboard][jenkins_dashboard] and build your new job
   (e.g. `mukund-web-build`) and build it.
   ![Example test job](images/test-job.png)

[add_collaborator]: https://help.github.com/articles/adding-collaborators-to-a-personal-repository/
[jenkins_dashboard]: https://jenkins.internal.justin.tv
[job_dsl_seed]: https://jenkins.internal.justin.tv/job/job-dsl-seed
[test-changes]: https://git.xarth.tv/release/jenkins-jobs#testing-your-job-script-with-gradle

### The deploy is created, but then nothing happens

This could mean there is a bug in our [skadi][] deploy listener.  Contact
someone in #devtools to look at the log file for errors.

[skadi]: https://git.xarth.tv/release/skadi

### I forked a repo, and it's not showing up. Please help!

Forked Repos are not supported in the deploy system at this time, due to the problems it causes with multiple duplicate jenkins jobs. This also means that workflows that use Fork -> PR for dealing with changes don't work either. 

Instead of forking a repo, please request from the repository owner to be add as a contributor. You can then clone the repo, push a branch and submit a PR directly to that repository.

Please contact #devtools if you have any questions about this.
