# Email Notifications

The new email notification feature in skadi will send messages to configured
addresses for environments on deployment status updates.

![example email](images/notification_example_email.png)

## Recommended - Setting up Your GitHub Enterprise Profile

Skadi uses your GitHub profile information to determine the full name and email
address of the user who triggered the deploy. If the information is available,
it will send the notification from the address of the user. Otherwise, the email
will be from devtools@justin.tv. In either case, the full name of the user will
be visible in the From address.

Set your GitHub profile email address at
https://git.xarth.tv/settings/profile

![github profile](images/notification_github_profile.png)


## Configuring Your Environments

Notifications for each repo are configured for environments in `deploy.json`. Organization-wide notifications can be set up through clean-deploy.internal.justin.tv.

Both org-wide and repo-specific deployment notifications are supported. If the same email address is in the org-wide setting and in the deploy.json of the repo being deployed to, then the settings for that email address listed in deploy.json will be used instead of the org-wide settings when deploys happen in that repo. As such, deploy.json subscription emails can be used to override org-wide settings.

### Notifications per repo

Inside an _environment_  definition, a new `subscriptions` field has been added.
The `subscriptions` field lists email addresses that should receive
notifications when a deployment status is updated. The boolean fields `success`,
`pending`, and `failure` in a _subscription_ definition determine on which
deployment statuses to notify. If a field is omitted, it will default to
*false*.

```json
{
  ...
  "environments": {
    "staging": {"job": "web-jax-deploy-staging-overide"},
    "production": {
      "subscriptions": {
        "change@justin.tv": {"success": true, "pending": false, "failure": true}
      }
    }
  },
  ...
}
```


### Notifications across an org

To add email notifications to an org, go to https://clean-deploy.internal.justin.tv/#/home and use the gear icon next to the org. When you click it, you will be directed to the org-wide settings page, where you can add/edit/delete email addresses for pending/success/failure deployment events.

Using this UI, you can also disable or enable email notifications per environment or for all environments. For example, you can opt-out of email notifications to deploys on 'staging' across your org, or opt-in to email notifications for all 'production'.

Please note that any subscriptions listed in a deploy.json "subscriptions" field will override any org-wide settings.

### Deployment Statuses

**Success**

The deployment finished successfully.

**Pending**

The deployment has started.

**Failure**

The deployment failed or encountered an unexpected error.

## New Deployment Fields: Code Review and Risk Assessment

Enabling notifications on an environment enables two new fields in the
deployment dialog, _Code Review_ and _Risk Assessment_. _Code Review_ is
optional, but must contain a valid URL. _Risk Assessment_ is required. These
fields are not present when deploying to environments without notifications.

![deploy dialog](images/notification_deploy_dialog.png)
