# Snapshots

Snapshots is a new feature in Deploy that enables teams to merge multiple branches into a single artifact and deploy said artifact. Snapshots was built around our existing deployment pipeline, in that we built an API that will take X number of git refs and merge them into a single branch, push the branch to our git-aws instance, which will then trigger the build process. After the snapshot branch successfully builds, then it becomes an artifact and is deployable to any other environment. The snapshot feature has been requested by some teams as becoming an important part of their workflow, as it makes it easier to keep track of specific versions of deployable artifacts. Snapshots should be semantically named with a description of the purpose of the snapshot under it, thus making it easier to keep track of deployable artifacts at specific points in time.

### V1

This is V1, your feedback on any desired features or additions is requested. We want to make this as good as it can be. Some things we are already considering for V2 include using tags instead of branches, clone-and-edit functionality, more metadata, and a cleaner UI. If you have any additional feature requests please emaildevtools@twitch.tv or file a Jira ticket in DTA.

## How to use Snapshots

**[1]** Visit a repo view page, such as https://clean-deploy.internal.justin.tv/#/video/usher

![snapshot](images/snapshot_01.png)
*Notice the new Snapshots listing above the list of Branches, this is where our new Snapshots will be displayed.*

**[2]** Click on "Create Snapshot" under the "Freeze <repo>" button

![snapshot](images/snapshot_02.png)

**[3]** Now you can select SHAs to be used as refs to created your merged state. To pick a specific SHA that is not at the tip of a branch you can click the caret icon to the right of a branch name, similar how you can on the regular repo view page.

![snapshot](images/snapshot_03.png)
*Notice that the larger checkbox means that the tip of the brach is selected, which is that specific SHA. If any SHA from a branch is selected that branch will be highlighted.*

**[4]** Now that you have selected your SHAs you can name your snapshot. Snapshot must be unique to any existing branch name on GHE, and must be a valid branch name. If you name your snapshot integration_test, then the corresponding branch that will be created by the API would be called snapshot_integration_test. This is noted in the UI.

![snapshot](images/snapshot_04.png)

**[5]** Once you press "Create Snapshot" the API will start working on merging your refs. Most of the time is used in cloning the repo, so if your repo takes a long time to clone, then the API will take about that much time. You will get a confirmation modal which will either say success or merge conflict.Important: Resolve conflicts then externally.

a. On success:

![snapshot](images/snapshot_05_a.png)

b. On conflict:

![snapshot](images/snapshot_05_b.png)

**[6]** If your snapshot's corresponding branch created a successful artifact, which will be noted by the green check, then you are able to deploy this snapshot to any environment.

![snapshot](images/snapshot_06.png)

**[7]** Deploy a snapshot just like you would a branch, essentially it is the same workflow in the deployment pipeline from this point. But a snapshot will always be the same, making it more semantical than telling your team to always deploy X SHA from X branch.

![snapshot](images/snapshot_07.png)

**[8]** Once your team is done with your snapshot you can delete it. This will delete the corresponding branch created to build the snapshot stored on origin.

![snapshot](images/snapshot_08.png)

Again this is just V1, please share your feedback. We take your feedback very seriously on Dev Tools, as you are our users, and we aim to not prescribe, but to build tools that can be used effectively in our diverse work environment. We have taken the feedback of Freeze V1, and will be working on incorporating much of that feedback in V2. Likewise there will be a V2 of Snapshots, what's most important to you?
