# Docker Registry


This doc describes the internal docker registry at Twitch!


* Endpoint: `docker.internal.justin.tv`

**Usage:**
* `docker tag <image> docker.internal.justin.tv/<team name>/<image>:<tag>` </br>
* `docker push docker.internal.justin.tv/<team name>/<image>:<tag>`

**What's Stored in docker.internal.justin.tv?**
* `curl -s -XGET https://docker.internal.justin.tv/v2/_catalog` - will provide a list of all images in the registry.
* `curl -s -XGET https://docker.internal.justin.tv/v2/<image name>/tags/list` - will list all tags for the given image

The nodes for the internal docker registry at twitch can be found by logging into the aws console for the twitch-core-services account and doing a search for `prod-dta-docker-registry` under instances

**Best Practices:**
* When creating an image inside of the docker registry, the following pattern should be used. 
* `docker tag docker.internal.justin.tv/<team name>/<image>:<tag>` 
* This will help with regard to namespacing within the docker registry.

**Archtecture:**
![Docker Registry](images/docker-registry.png)
