Custom Hacks
============

**Go get Proxy should no longer be needed since we switched to code.justin.tv**

Go Get Proxy
------------

In crontab for the admin user we have the following two entries:

```
@reboot /home/admin/gogetproxy -public-name git.xarth.tv -data=0.0.0.0:4445 -proxy=0.0.0.0:4444 -upstream https://git.xarth.tv:443
@reboot /home/admin/stunnel4 /home/admin/stunnel/stunnel.conf
```


To manually start go get proxy:

```bash
nohup /home/admin/gogetproxy -public-name git.xarth.tv -data=0.0.0.0:4445 -proxy=0.0.0.0:4444 -upstream https://git.xarth.tv:443 &
```

Run `ghe-unlock` to get sudo access.

In `/etc/ufw/before.rules` append the following lines:

```
# Add custom rules for twitch
*nat
:PREROUTING ACCEPT [0:0]
:INPUT ACCEPT [0:0]
:OUTPUT ACCEPT [12:903]
:POSTROUTING ACCEPT [12:903]
:INTERNAL - [0:0]
-A PREROUTING -i eth0 -p tcp -m tcp --dport 443 -j REDIRECT --to-ports 4443
COMMIT
```

Load the settings `sudo ufw reload`

Remove sudo rights `ghe-lock`

In theory this will no longer be needed after the next edition of github.

Firewall
--------

Setup the firewall:

```bash
sudo ufw allow out to 10.0.0.0/8
sudo ufw allow out to 192.168.0.0/16
sudo ufw allow out to 192.16.64.0/21
sudo ufw allow out to 199.9.248.0/21
sudo ufw allow out to 185.42.204.0/22
sudo ufw allow out to 33.99.10.96/29
sudo ufw allow out to 127.0.0.1/32
sudo ufw allow out to 45.113.128.0/22
sudo ufw allow out to 103.53.48.0/22

sudo ufw allow from 10.0.0.0/8
sudo ufw allow from 192.168.0.0/16
sudo ufw allow from 192.16.64.0/21
sudo ufw allow from 199.9.248.0/21
sudo ufw allow from 185.42.204.0/22
sudo ufw allow from 33.99.10.96/29
sudo ufw allow from 127.0.0.1/32
sudo ufw allow from 45.113.128.0/22
sudo ufw allow from 103.53.48.0/22

sudo ufw default deny incoming
```

On restart ensure these rules are still present. And running.

Maintenance
===========

Getting SSH Access
------------------

You don't use port 22 to SSH to the server, you need to run:

```ssh -p 122 admin@git.xarth.tv```

SSH access is only granted to the users that have their SSH key deployed to
the system.

The process for adding/removing SSH keys are identical to the options for
changing any other settings.

See [Github's docs](https://help.github.com/enterprise/2.6/admin/guides/installation/administrative-shell-ssh-access/) for more details.


Preforming Upgrades
-------------------

If you need to either update the license or upgrade the software the process
is basically the same.

1. Go to enterprise.github.com and login.

2. Download the license. This is needed regardless.

3. If you are upgrading the software download the new software package.

4. Go to git.xarth.tv/setup

5. Login using the license file downloaded above.

6. Put github into maintenance mode.

7. Go to "Upgrade" section.

8. Upload license file.

9. Optionally upload new software.

10. Wait a large amount of time.

11. Take out of maintenance mode.

Changing Settings
-----------------

1. Go to git.xarth.tv/setup

2. Upload the license file to login.

3. Go to the settings tab.

4. Make changes.

5. Click save button at the bottom of the page.

6. Wait for 5-25 minutes for the settings to apply.
   **Note: During this time git.xarth.tv will be unaccessible for normal operation.**

7. ???

8. Profit!
