# Devtools private NPM repository/cache

# This NPM repository has been deprecated

The current NPM repository that should be used is located on our [Artifactory cluster][artifactory].

You can find info about the NPM Artifactory cluster at:

- https://git.xarth.tv/dta/docs/blob/master/npm.md
- https://twitchtv.atlassian.net/wiki/display/ENG/Artifactory

Due to the complexity of copying all of the data from the old service to the new service, we're asking developers to update their projects to use the new NPM server as soon as time permits.  See the documentation linked above for details about using the new NPM repostiory as well as the procedure for uploading NPM modules.


## Overview

The Devtools private NPM repository is using an open source software called [Elephant][1]. It can be used as a local proxy/cache for NPM modules as well as a store for private modules.  When an NPM module is requested, Elephant first looks in it's local cache for the package.  If a local copy exists, it is returned to the user.  If not, the package is pulled from npmjs.org and sent to the user while saving a copy locally for future requests.

## Using as a proxy/cache

There are 2 private NPM repositories.  1 for production and another for development.

|environment|endpoint|
|-----------|--------|
|development|https://npm-registry-dev-def.internal.justin.tv|
|production|https://npm-registry-prod-def.internal.justin.tv|

To use one of the private npm registries, run `npm set registry <endpoint>`


## Uploading modules to the private repository

In order to push modules to the private registry, **you must first login** to the registry. `npm login --registry <endpoint>`.  You will be prompted for a username, password and email address.  The username/password is: npm_user/npm_user.  You can use any email address.

After you are authenticated with the npm registry, you can publish npm modules using `npm publish`

It is **strongly** suggested to put the registry URL in `.npmrc` (like in [web/styles](https://git.xarth.tv/web/styles/blob/master/.npmrc)) so the default registry for your project is the private NPM repository.

## Trouble?

Contact the devtools team at [dta@justin.tv][2].


[1]: https://github.com/dickeyxxx/elephant
[2]: devtools@justin.tv
[artifactory]: https://twitchtv.atlassian.net/wiki/display/ENG/Artifactory
