# Puppet & Consul

In order for your servers to be discovered as deploy targets, they need to have a Consul service attached to them. In [Puppet](https://git.xarth.tv/systems/puppet), declare a service for your application and tag it with the appropriate environment. (i.e. "staging", or "production"). If you aren't sure how to do this, below is a basic example to get you started.

## Create a Puppet module for your service

By following this example, you will create a new puppet module for your service which registers in consul.

First, create a new directory in the [Puppet](https://git.xarth.tv/systems/puppet) repo under [modules](https://git.xarth.tv/systems/puppet/tree/master/modules), named for your project. Inside it create a "manifests" folder. Create the following files:

```puppet
# modules/my_app/manifests/init.pp
class my_app (
  $deploy_env = $my_app::params::deploy_env
) inherits my_app::params {
  class { 'my_app::install': }
}

# modules/my_app/manifests/install.pp
class my_app::install inherits my_app {
  consul::service { 'deploy-target-my_app':
    consul_tags    => [$deploy_env],
  }
}

# modules/my_app/manifests/params.pp
class my_app::params {
	$deploy_env = 'production'
}
```

#### Daemon/Upstart/Basic Logging Configuration:

If you require a deamon or an upstart-like service, below is a basic example of how to do that within your init.pp file using [daemontools](https://git.xarth.tv/systems/puppet/tree/master/modules/daemontools). This will also write your services logging output to `/var/log/jtv/your-service-name.log`.

```puppet
# modules/my_app/manifests/init.pp
class my_app (
  $deploy_env = $my_app::params::deploy_env
) inherits my_app::params {
  class { 'my_app::install': }
  
  daemontools::supervise{ 'my_app':
    syslog     => 'local3',
    wd         => '/opt/twitch/my_app/current',
    daemon     => './my_app_run_command',
    options    => '2>&1',
    daemon_dir => '/var/lib/service',
    user       => 'nobody',
  }
}
```

## Define which boxes belong to each enviroment.

In the Puppet [hiera](https://git.xarth.tv/systems/puppet/tree/master/hiera/cluster) directory, edit or create files which specify that this module should be installed on them, and set the variables we defined above.



```yaml
# /puppet/hiera/cluster/my_app.yaml
---
  classes:
    - my_app

my_app::my_app_environment: staging
my_app::http_port: 80
```
