# [Production-ready Go services from scratch](shipping_a_new_app.md)

* [Continuous Integration](#continuous-integration)
	* [Automated builds](#automated-builds)
	
## Continuous Integration

Twitch projects use continuous integration patterns where every commit to a repository is run through the build and test process to ensure it is safe for release. The CI system is driven by Jenkins and integrates with Github pull requests and our deploy tool.

Getting your application hooked into the build and deploy pipeline first is recommended to allow all future steps of this guide to be deployed as normal application updates. At this stage, your Go application should be devoid of any real logic, other than acting as a daemon and not exiting when run successfully.

```go
// main.go
package main

func main() {
	for {}
}
```

### Automated builds

Twitch uses linux containers to run our builds and unit test suites. The [manta](https://git.xarth.tv/release/manta-style) tool manages these containers, and your build is expected to be defined as a manta config file.

A manta file for Go projects looks like:

```json
{
  "image": "ubuntu:precise",
  "mount": "/go/src/code.justin.tv/myorg/myrepo",
  "env": [
    "PATH=/go/bin/:/usr/local/go/bin:$PATH",
    "GOPATH=/go:/go/src/code.justin.tv/myorg/myrepo/Godeps/_workspace"
  ],
  "setup": [
    "apt-get update && apt-get install -y curl git build-essential",
    "curl -LO http://golang.org/dl/go1.5.linux-amd64.tar.gz",
    "echo \"5817fa4b2252afdb02e11e8b9dc1d9173ef3bd5a  go1.5.linux-amd64.tar.gz\" | sha1sum --check",
    "tar -C /usr/local -xzf go1.5.linux-amd64.tar.gz",
    "go get github.com/kisielk/errcheck",
    "go get github.com/golang/lint/golint"
  ],
  "build": [
    "go vet ./...",
    "errcheck -blank ./...",
    "golint ./...",
    "go test -race ./...",
    "go build -tags 'netgo'"
  ],
  "extract": {
    "source": "/go/src/code.justin.tv/myorg/myrepo/mybinary",
    "destination": ".manta/"
  }
}
```

**Note**: Running `go vet`, `errcheck`, and using the `-race` flag on `go test` are recommended for all go projects.

- [ ] Create a `build.json` manta config in your repository which extracts your compiled binary.

To have this build process run every commit, define a build job which executes `manta -f build.json` every time a commit is added to any branch of your project. Detailed instruction's can be found in [devtools documentation](https://git.xarth.tv/twitch/docs/blob/master/release/deploy.md#2-define-build-job-in-jenkins).

- [ ] Define a build job inside `jenkins.groovy` in your repository.
- [ ] Confirm that new commits trigger builds automatically.
