# [Production-ready Go services from scratch](shipping_a_new_app.md)

* [Preparing your development environment](#preparing-your-development-environment)
  * [Go](#go)
  * [godep](#godep)
  * [golint / godoc](#golint--godoc)
  * [goimports](#goimports)
* [Vagrantfile](#vagrantfile)

## Preparing your development environment

This part of the guide is opinionated around using Vagrant to automate your development environment. By using a VM for development, this allows you to easily run the full `manta` build for your project without needing to wait for Jenkins to build your project after committing.

#### Go

https://golang.org/doc/install

#### godep

The accepted Twitch pattern for managing dependencies is to vendor 3rd party code using the [godep](https://github.com/tools/godep) tool.

#### golint / godoc

[golint](https://github.com/golang/lint) is the primary go linter, and using it will help you manage how others view your documententation on our [godoc server](https://godoc.internal.justin.tv/).

#### goimports

[goimports](https://github.com/bradfitz/goimports) is a wrapper around `go fmt` which also adds and removes import statements based on their usage in each file. Hooking this up to your code editor to run each time you save a file is recommended!

## Vagrantfile

Using the following examples, you can provide your project a starting point to install all the tools just mentioned in a reproducible way. As your needs change, these files can easily be updated to manage your development environment.

```ruby
# Vagrantfile
Vagrant.configure("2") do |config|
  config.vm.box = "ubuntu-12.04-amd64-docker-1426195046"
  config.vm.box_url = "http://devtools-vagrant-images.s3.amazonaws.com/ubuntu-12.04-amd64-docker-1426195046.box"
  config.vm.provision "shell", path: "scripts/vagrant.sh"
  config.ssh.forward_agent = true
  config.vm.synced_folder ".", "/go/src/code.justin.tv/myorg/myrepo"
end
```

```bash
# scripts/vagrant.sh
apt-get update
apt-get install -y manta

wget https://storage.googleapis.com/golang/go1.5.linux-amd64.tar.gz
echo "5817fa4b2252afdb02e11e8b9dc1d9173ef3bd5a  go1.5.linux-amd64.tar.gz" | sha1sum --check
tar -C /usr/local -xzf go1.5.linux-amd64.tar.gz

echo '
export PATH="/usr/local/go/bin:/go/bin/:$PATH"
export GOPATH="/go"
' >> /home/vagrant/.profile

source /home/vagrant/.profile

apt-get -y install git mercurial
go get github.com/golang/lint/golint
go get golang.org/x/tools/cmd/goimports
go get github.com/tools/godep

chown -R vagrant:vagrant /go
```

To launch and start hacking on Go, run:

```bash
vagrant up
vagrant ssh
cd /go/src/code.justin.tv/myorg/myrepo # edit this in Vagrantfile
```

- [ ] Add a `Vagrantfile` to your repository, and ssh into a running VM
