# [Production-ready Go services from scratch](shipping_a_new_app.md)

* [Define HTTP endpoints](#define-http-endpoints)
* [Enable debug profiling](#enable-debug-profiling)

## Define HTTP endpoints

We've had success using the [goji/web](https://github.com/zenazn/goji) library for making life easier when defining HTTP endpoints. Due to this, we have created a wrapping library at [common/twitchhttp](https://git.xarth.tv/common/twitchhttp) to make it easier to spin up goji-based HTTP servers.

```go
// api/api.go
package api

import (
  "net/http"

  "code.justin.tv/common/twitchhttp"
  "github.com/zenazn/goji/web"
  "golang.org/x/net/context"
)

type Server struct {
  *twitchhttp.Server
}

func NewServer() (*Server, error) {
  server, err := twitchhttp.NewServer()
  if err != nil {
    return nil, err
  }

  s := &Server{server}

  s.Get("/v1/thing", s.doThing)

  return s, nil
}

// api/thing.go
package api

import (
  "fmt"
  "net/http"

  "github.com/zenazn/goji/web"
  "golang.org/x/net/context"
)

func (s *Server) doThing(ctx context.Context, c web.C, w http.ResponseWriter, r *http.Request) {
  fmt.Fprintf(w, "%s", "OK")
}

// main.go
server, err := api.NewServer()
if err != nil {
  log.Fatal(err)
}
log.Fatal(server.ListenAndServe())
```

**Note**: The `Server` struct we defined utilizes the concept of "embedding" when it includes the `*twitchhttp.Server` struct. For a detailed explanation of how this works, refer to [that section in "Effective Go"](https://golang.org/doc/effective_go.html#embedding)

- [ ] Start your application and confirm you can `curl http://localhost:8000/v1/thing`
