# [Production-ready Go services from scratch](shipping_a_new_app.md)

* [Trace integration](#trace-integration)
	* [1. Add <code>barrel</code> service to your application hosts.](#1-add-barrel-service-to-your-application-hosts)
	* [2. Generate a <code>chitin.Context</code> each request](#2-generate-a-chitincontext-each-request)
* [Instrument Go runtime metrics](#instrument-go-runtime-metrics)
* [Error reporting](#error-reporting)
	* [Sending panics to Rollbar](#sending-panics-to-rollbar)
* [Pagerduty alerts](#pagerduty-alerts)

## Trace integration

[Trace](https://trace.internal.justin.tv/) is Twitch's in-house request logging system which enables following an edge request through all the services it uses.  By using [Chitin](https://git.xarth.tv/common/chitin) to generate a per-request `Context` object, your requests will automatically populate Trace reports.

In addition to producing transaction reports, Trace generates standardized Graphite metrics for your endpoints. This allows you to add latency, throughput and error rate graphs to your [Grafana](http://grafana.prod.us-west2.justin.tv/) dashboard.

By using `twitchhttp.Server` your service automatically reports to Trace. But you need to ensure that the local ingest process is running on your application hosts. In the puppet hiera cluster you defined previously, add the `twitch_barrel` module. Running puppet on your nodes should install everything else you need.

```yaml
---
classes:
  - my_module
  - twitch_barrel
```

- [ ] Send some requests to your new trace-enabled service in the staging environment, and view the results at [trace.internal.justin.tv](https://trace.internal.justin.tv)

## Error reporting

Many Twitch applications use the [Rollbar](https://rollbar.com/) service to aggregate errors from production.  You can use our [simple wrapper](https://git.xarth.tv/common/golibs/tree/master/errorlogger) to send errors and panics generated by HTTP requests.

Before we start sending errors, you need to get an account. (Ask your manager to invite you) Once you are logged in, you should create a new "Project" for your app in Rollbar. This will generate a unique server-side token which you will use to configure your application.

- [ ] Create a new Rollbar project and add the API token as a configuration flag for your app.

Now we are ready to teach our app how to send errors. By using `common/config` your application is already configurable. When executing, pass in the token such as: `go run main.go -rollbar-token deadbeef`. With this set, you can reference `config.RollbarErrorLogger()` whenever you want to send report an error.

```go
// api/api.go
func (s *Server) serveError(w http.ResponseWriter, r *http.Request, err error, status int) {
	w.WriteHeader(status)

	if status >= 500 {
		config.RollbarErrorLogger().RequestError(r, err)
	}
}
// api/thing.go
s.serveError(w, r, err, http.StatusInternalServerError)
```

- [ ] Deploy a version of your app where `Backend.DoThing()` always returns an error and confirm you see the error in Rollbar.

## Pagerduty alerts

Before you can go to sleep with your app running in production, you need to make sure that if something goes wrong you can be alerted.  We use Pagerduty at Twitch, so first you should get an account. (Talk to your manager or #systems to get set up). It is also recommended that you install the Pagerduty mobile app for easier alert response.

The way Pagerduty is designed, you will create a "Service" for each source of alerts. In this example, Rollbar will be the source.  Each service is mapped to an "Escalation Policy" which dictates who gets notified. The policy needs to exist first before you create a service.

Pagerduty -> Configuration -> Escalation Policies -> New Escalation Policy

Create a policy which contains your user as the only target. As your project grows you can eventually create a rotating calendar for on-call schedules.

Pagerduty -> Configuration -> Services -> Add New Service

- Name: "myapp - Rollbar"
- Escalation Policy: see above
- Integration Type: Rollbar

After saving your service, you will see a generated "Service API Key".

Rollbar -> Settings -> Notifications -> Pagerduty

Paste your Pagerduty key and enable notifications. You can then customize the alert thresholds.

- [ ] Trigger another rollbar error through your application, and confirm you receive a Pagerduty alert. Depending on your thresholds, you may need to trip the error a number of times before being alerted.
