# Owl

Owl is Twitch's implementation of OAuth2, used by our web API, TMI, and SSO. It validates and creates OAuth tokens.

## On-call

[Hosts](http://consul.internal.justin.tv/ui/dist/#/sfo01/services/owl)

Owl is stateless and is always safe to restart. Any box can also be downed.

`sudo svc -i /etc/service/owl`

Logs can be found in `/var/log/jtv/owl.log`

[Error reporting](https://app.getsentry.com/twitchtv/owl/)

## API

[API](https://git.xarth.tv/web/owl/blob/master/doc/api.md)

## Backend

Owl uses a 3 node cassandra cluster: `auth-cassandra-6ba550`, `auth-cassandra-6f4ca8`, `auth-cassandra-6f4918`

As part of our Cassandra transition, Cassandra support can be controlled through the following flags (in `/etc/service/owl/run`):

    CASSANDRA_RENDER_PORTION (0-1): What portion of validation requests should be rendered based on Cassandra
        Disable if validation is returning incorrect results.
    CASSANDRA_PORTION (0-1): What portion of requests should be mirrored to Cassandra.
        Disable because of Cassandra performance issues.

OAuth client data is stored in the SQL `oauth2_clients` table.

[Schema](https://git.xarth.tv/web/owl/blob/master/doc/schema.md)

## Monitoring

[Owl graphs](http://grafana.prod.us-west2.justin.tv/dashboard/db/owl)

[Cassandra graphs](http://auth-cassandra-6f4ca8.sfo01.justin.tv:8888/opscenter/index.html)

[Owl Ganglia](https://ganglia.internal.justin.tv/?c=owl&m=load_one&r=hour&s=by%20name&hc=4&mc=2)

[Cassandra Ganglia](https://ganglia.internal.justin.tv/?c=auth-cassandra&m=load_one&r=hour&s=by%20name&hc=4&mc=2)
