# Buddy Guide

Congratulations! You have demonstrated enough maturity and engineering prowess to be responsible for another human being for one day (or longer).

## Before the first day
### Team Lead and Buddies
* Prepare a small task in advance that can be done in less than half an hour.
* Notify QA in advance that their time will be needed, and that existing QA tasks may need to be interrupted.

### IT tasks
* Prepare a machine (generally a MacBook Pro) for the engineer.
Currently our setup guide supports both Mavericks (10.9) and Yosemite (10.10).

### Potential TODOs:
 * Have laptops come with the development environment already set up.
 * Ask new engineers for a username before their first day.

## First Day
### Setting up
Note that a lot of these instructions will be mirrored in the [starting guide](new.md) for the new engineer. 
* Set up two-factor authentication for them via [active admin](https://admin.internal.twitch.tv/auth/ldap). Ping someone who knows how to set up staff accounts afterwards (Aaron Clay?).
* Add the engineer to the appropriate git repositories.
  * [web](https://git.xarth.tv/orgs/web/teams/owners).
* Add the engineer to our [engineering wiki](https://git.xarth.tv/orgs/twitch/teams/engineering).
* Add the engineer to relevant [mailing lists](mailing_lists.md).
* Get the engineer into [Slack](https://www.slack.com/). Get them into your team specific room at the very least, introduce them, give introductions, etc...
* Assign the aforementioned task to the engineer in [JIRA](https://twitchtv.atlassian.net/).

### Pushing Code
1. Be available to CR.
  * Make sure to ask for a test plan.
2. Make sure the engineer keeps the JIRA board up-to-date.
  * Status (Doing, CR, QA)
  * Phabricator Links (for test plans).
3. Make sure they write an email to change@twitch.tv, containing in any particular order:
  * Phabriactor Link
  * Summary of changes made. 
  * Risk assessment
4. Join in celebrating their first code push making sure to use lots of capitalizations and exclamation marks, and then never celebrate any of their subsequent code pushes again. Welcome to the real world.

## Document TODOs
* General work flow (sprint, project, roadmaps, etc).
* Outline of technologies, teams, architectures (link to internal documents when possible, networks are good).
