# New Engineer Guide
Congratulations! You're an engineer at Twitch. Today will likely be the earliest you show up to work for a very long time.

## Accounts and Access
### VPN
Before you take your laptop home for the first time, you should ensure you have access to the [Twitch VPN](https://wiki.twitch.com/display/HD/Twitch+VPN). That wiki page has detailed steps for installing the VPN software, selecting a VPN server, and registering your 2-factor application.

### Twitch.tv Staff Account
Want your wrench? ![](https://static-cdn.jtvnw.net/badges/v1/d97c37bd-a6f5-4c38-8f57-4e4bef88af34/1) Twitch Staff members [display a special chat badge](http://help.twitch.tv/customer/portal/articles/659115-chat-icons-and-emoticons) to allow viewers to know you help create the fun experience they are having.

1. Create a Twitch account if you do not already have one.
  - *Please do not use "twitch" or "twitchtv" in your username.*
  - *If you would like a specific name which is not available, please contact [supportteam@twitch.tv](mailto:supportteam@twitch.tv)* for review.
2. Add and verify your @twitch.tv email on your Twitch account via your [Profile Settings](https://www.twitch.tv/settings/profile).
3. Enable Two-factor authentication on your Twitch account via your [Security Settings](https://www.twitch.tv/settings/security).
4. Send an email to [supportteam@twitch.tv](mailto:supportteam@twitch.tv) requesting a Staff account.
5. We will walk you through the rest of the process of creating a staff account ( including anything you may have missed. )
  - *Please read the guidelines below on best practices around using your staff account on the Twitch site.*

**Things to remember when using a Staff account:**
- Staff badges make employees easily identifiable in both chat and, regardless of participation, at the top of the Viewer List.
  - Avoid joining controversial channels ( such as any linked in the Slack #moderation channel ) while logged in.
- Unless you have been given a Moderator badge by the broadcaster, please leave chat moderation to the broadcaster and their designated moderators.
- If you witness conduct that may violate our Terms of Service or Rules of Conduct, click “Report” under the Gear icon. This report will be handled by our 24/7 Moderation team.
  - DO NOT click “ToS Strike” under the Gear icon to suspend a channel, for any reason. Only the moderation team may use this functionality.
- Staff accounts provide more UI privileges than necessary. In the event of encountering an unfamiliar function or button, consult the Support team before using it, or do not touch it.
- If a broadcaster asks you for technical support or help, route the question to the Support team by having the user file a ticket via [help.twitch.tv](https://help.twitch.tv/).
- Forward all requests for favors or questions from Partners to [partnerhelp@twitch.tv](mailto:partnerhelp@twitch.tv) or send a message to the #Partnerships Slack channel.
  - Partners are easily identifiable by the “Subscribe” button on their channel.
  - Partners who log in before submitting a ticket via [help.twitch.tv](https://help.twitch.tv/) will automatically be routed to PartnerHelp.
- Twitch Reddit is neither moderated nor managed by Twitch. Offer to help, but do not offer opinions or disclose confidential information.
- Staging web-client uses the production TMI stack unless otherwise noted, so avoid testing in your own chat on staging
- Do not use addons like BTTV or FFZ with your staff account, since this effectively gives full access to your account to a third party.

If you wish to chat and participate in Twitch community activities without being externally identified as staff, feel free to create a separate account and alias.

> Always remember that you represent Twitch when you use these accounts on the public Internet. Think quickly, type slowly.


### AWS

Most Twitch infrastructure (except key pieces of the Live Video system) run on AWS. In order to help manage your team's existing resources and provision new ones, you will need to be given access to your team's AWS Account.

- __AWS Account__: Team-level collection of environments, services and network settings. `twitch-web-aws` and `twitch-video-aws` are examples of AWS accounts for the Web and Video teams, respectively.
- __IAM User__: Your individual privileges to access resources in a given AWS account. You will have an IAM user for each AWS account, each with their own credentials.

Ask your buddy which AWS accounts you will need access to for your team, and have them create an IAM user for you.  After you login for the first time, you will need to enable 2-factor authentication.

After setting up 2-factor authentication, navigate to "Identity & Access Management", then select "Users".  Search for your user name and select the "Security Credentials" tab. Under the "Access Keys", choose to create a new Access Key. Keep these handy since you'll need them for the next step.

Next, [install the AWS CLI tool](http://docs.aws.amazon.com/cli/latest/userguide/installing.html). After installation, run `aws configure` and input the key and secret value you created in the previous step.  Your account and local environment is now ready to run AWS-authenticated requests.

## Communication Tools
### Slack
We use Slack for most real-time communication and chat rooms at Twitch. Install [Slack](https://twitch.slack.com/) or just use the web interface there. You are able to change your Slack name to whatever you want, and others can use @yourname to get your attention. It is recommended to fill out your Slack profile so that remote employees can better understand who you are and your role at the company. To do this, select "Profile & account" under the main "Twitch" menu.

There are hundreds of chat rooms on Slack available to you.  In order to help find ones which interest you, use our [Slack Channel Catalog Tool](http://slack.internal.justin.tv/). You can help categorize your team's channels by using #hashtags in the "channel purpose" field.

### JIRA

Most teams use [JIRA](https://twitchtv.atlassian.net/) to track tasks and milestones. Select "Log in using Google" and use your @justin.tv account to gain access.

Your team will walk you through how to manage and update your tasks (ex: Kanban vs Scrum).

### Mailing Lists

You probably want in on a couple of lists related to what you and your team do at Twitch. You can discover interesting lists and edit your memberships from the [Google Group manager](http://gaps.sci.twitch.tv/subs).

## Coding

### Development Environment

Each project you work on should have a guide on setting up the requirements to get work done. If you can't find one, remind your buddy it should exist and help write it!

Other aspects of your development environment are shared across projects and should be setup now.

#### Admin Privileges

For Amazon imaged machines, you may need to enable admin privileges for your user account. Open `System Preferences`, click `Acme` in the bottom left, click `Settings` and then `Request for Admin Access`.

#### Github Organizations

Code repositories at Twitch are spread across many Github Organizations based on who owns the system.  Ask your buddy to add you to the organization (ex: `web` or `video`) which contains the projects you will be working on.

If later you need access to another organization, then you can contact that team directly in slack and ask for access.

#### SSH Keys

In order to access Github repositories via SSH, you need to register your computer. This is done by generating an SSH key, and uploading it to [Github using the settings page](https://git.xarth.tv/settings/keys). Refer to [Github's documentation](https://help.github.com/enterprise/2.6/user/articles/generating-an-ssh-key/) for how to generate an SSH key and add it to your account.

__(Optional)__ When logging into servers via SSH, you will be prompted for your LDAP password. If you want to login to servers using your public key, you can [add your SSH key to your LDAP account](https://twitchtv.atlassian.net/wiki/display/SYS/SSH+Access).

### Developer Workflow

While each team may vary from this workflow slightly, the basic path to get code to production is as follows:

#### 1. Write code

Projects at Twitch are implemented using a variety of languages. The primary languages are __Go__ and __Javascript__. You will also find older applications written in either __Ruby__ or __Python__. In general, __Go__ is the preferred language for any new service being created at Twitch.

Your changes should be committed to a named feature branch and pushed to [Github](https://git.xarth.tv/). This allows our automated build system to prepare your changes for deployment.

#### 2a. Write tests

Code at Twitch is expected to be covered with unit-level tests which run after each commit. When contributing to an existing project, this automated test run should already be configured and you simply need to write and commit your tests. Chat with your buddy about what level of testing is expected for the particular projects you are working on, as some of the legacy apps may have different requirements.

#### 2b. Vet your changes

Ask your buddy about what pre-production options exist for testing your application.  For some apps, the automated unit tests are robust enough to give confidence that a production deploy will go smoothly. For other projects, there may be environments such as `staging` or `testing` which you can target for deploys. Generally these environments fall into two categories:

- __Production verification__: For backend systems, many teams have environments (sometimes referred to as `canary`, `testing` or `darklaunch`) which sends a portion of production traffic to an application running a specific branch. This provides a way to sanity check changes before they are merged to master.
- __Manual testing__: For many UI-driven applications such as the Javascript web application, it helps to deploy to a `staging` environment which allows multiple developers and QA staff to interact with the application by hand.

#### 3. Get your changes reviewed and merged into the master branch

The default way to get your code reviewed is to open a Pull Request on your project's repository. Github Pull Requests automatically integrate with the automated build system in order to provide feedback to you about the state of build. Share the link to the PR with your team, or assign it to a specific developer (such as your buddy) to get feedback. When your reviewers tell you the code is ready, use the Pull Request interface to merge your changes into the master branch.

A few teams use a tool called [Phabricator](phabricator.md) for reviews. Your buddy will let you know if this is the case.

#### 4. Deploy your changes
The [deploy tool](https://clean-deploy.internal.justin.tv/#/home) is the recommended way to ship new versions of applications to an environment (ex: `production`).  Your buddy will let you know if this isn't the case.

Using the deploy tool you can select a branch which is passing its tests, and update an environment to run that version. __Unless stated otherwise, you should only deploy the master branch to production environments__.

## Monitoring

### Grafana

https://grafana.internal.justin.tv/ - Login using LDAP credentials.

Twitch primarily uses statsd+graphite to record application and system metrics. The tool Grafana is used to make it easier to visualize these metrics and share them amongst teams. Feel free to surf around the available dashboards in the system using the `Home` dropdown. If your team uses additional tools for monitoring, your buddy will let you know.
