# Go

First read [The Go Style Guide](http://golang.org/s/style). In particular 
[Error Flow](https://code.google.com/p/go-wiki/wiki/CodeReviewComments#Indent_Error_Flow) 
and [Handle Errors](https://code.google.com/p/go-wiki/wiki/CodeReviewComments#Handle_Errors).

# Pre-Build

Before commiting or at least before building you should run:

* `go fmt` -- Formats and ensure that your code is valid go code. It is **strongly** recommended that you configure your editor to run this on save.
  - Optionally: `goimports` which will do everything `go fmt` does but will additionally adjust your 
                import statements as needed.

  Do not commit code that is not formatted with `gofmt`.

* `go vet` -- Test your code for common mistakes. This will catch a lot of valid go code which invalidly uses apis. 
              For example finding when you use a "%d" when you mean "%s" in a `fmt.Printf`.

  Code that fails `go vet` almost certainly has bugs and should not be committed. Committing code that fails `go vet` will weaken its ability to help your project later.

* `errcheck` -- Will discover where in your code you forgot to handle catch and deal with an error.

  Code that passes `errcheck -blank` probably has fewer bugs than code that doesn't pass `errcheck`.

* Optional: `golint` -- go lint will find places where you forgot doc strings, exported something that probably shouldn't 
                        be or other just bad style mistakes.

  Following the recommendations of `golint` may improve the quality of documentation for your packages (on godoc.internal.justin.tv), which could lead to less work for you later on.
  
# Coding Guidelines

### log.Fatal

`log.Fatal` and its companion `log.Fatalf` are both very useful api calls that
allow you to quickly say: "my application is in such a state that it is
impossible to continue". Care when using them should be exercised.

Use of calls to to `log.Fatal` should only really occur during the setup of a
program. In general this means the `init` and `main` functions.

The one other common place to use `log.Fatal` is `Must*` functions. For
example the `regexp` library has a `MustCompile` function. These will attempt
to do something and then `log.Fatal` if it fails. These are simply convenience
functions to assist in writing cleaner `main` and `init` functions.


### Must* functions

Must* functions are designed to make the setup of a program easier. As such
they really should only be used during `init` and `main`.

### time.After and time.Tick

`time.After` and `time.Tick` are both convenience functions for dealing with
time. The issue with them is that they create state within the runtime that lasts until the timer expires. In particular,
`time.Tick` will forever sit in the background of your program taking up
CPU and Memory, this will not be garbage collected at any point. `time.After` will consume CPU and Memory until its duration triggers, but this could result in a large amount of wasted memory even with a duration of a few seconds. Using them in
`main` is fine but not in sub-functions that are called frequently.

Timers will free their memory when they're ready. To exercise control over this, you should call `time.NewTicker` or `time.NewTimer` and then call `Stop` when the time is right (possibly with the help of `defer`).
