Examining incoming connections
==============================

Sometimes you want to keep track of who is connecting to your box so you can
see what service(s) depend on your own.

### Collect packet information ###

- Choose from the list of network interfaces available:

	```
	sudo tcpdump -D
	```

- Run tcpdump (replace INTERFACE and NODE_IP):

	```
	sudo timeout 30m tcpdump -n -i {INTERFACE} -c 300000 'dst {NODE_IP} and tcp[13] & 2 != 0 and tcp[13] & 16 = 0' > syn.log
	```

  	- Writes to `syn.log` file
	- timeout / -c flag mean that we'll stop logging packets after 30m or 300000 packets, whichever comes first
	- dst {NODE_IP} means the packet is incoming for the {NODE_IP}
	- tcp[13] & 2 != 0 if the SYN flag is set
	- tcp[13] & 16 = 0 if the ACK flag is not set

### Analyze packet information ###

- Count packets to specific ports by IP

	```
	cat syn.log | grep "IP" | perl -ne '$_ =~ /IP (\d{1,3}(\.\d{1,3}){3})\.\d+ > \d{1,3}(\.\d{1,3}){3}\.(\d+):/; print $1 . " " . $4 . "\n"' | sort | uniq -c | sort -bgr > ip_to_port.count
	```

  	- Writes to `ip_to_port.count` file
	- Lines formatted "{count} {ip} {dst-port}"

- Filter out ports you don't care about (IRC servers ignores 80,443,6667)

	```
	cat ip_to_port.count | perl -ne 'BEGIN { @ports = map{$_ => 1} qw(80 443 6667) } $line = $_; $line =~ /^\s*\d+\s+[^\s+]\s+(\d+)\s*$/; if(!$ports{$1}){ print $line }' > filtered_ip_to_port.count
	```

	- Skip this part if you care about all ports
	- Writes to `filtered_ip_to_port.count` file
	- Lines formatted "{count} {ip} {dst-port}"

- Find hostnames for IPs

	```
	cat filtered_ip_to_port.count | perl -ne 'BEGIN { @hosts = {} } $_ =~ /^(\s*\d+)\s+([^\s]+)\s+(\d+)\s*$/; $count = $1; $ip = $2; $port = $3; if(!$hosts{$ip}) { $host = `dig +short -x $ip`; $host =~ s/^\s+|\s+$//g; $hosts{$ip} = $host || $ip; } print $count . " " . $hosts{$ip} . " " . $port . "\n"' > filtered_host_to_port.count
	```

  	- Writes to `filtered_host_to_port.count` file
  	- Lines formatted "{count} {host-or-ip} {dst-port}"
