# Deployment

### Deployable Services

`NOTE: update these links when jenkins/deploy DNS entries are updated`

| Deploy | Jenkins Build | Jenkins Deploy | Boxes | Description |
| ------ | ------------- | -------------- | ----- | ----------- |
| [chat/tmi](https://clean-deploy.internal.justin.tv/#/chat/tmi) | [chat-tmi](http://jenkins-master-0.prod.us-west2.justin.tv/job/chat-tmi/) | [chat-tmi-deploy](http://jenkins-master-0.prod.us-west2.justin.tv/job/chat-tmi-deploy/) | tmi-main-, tmi-group-, tmi-event-, tmi-darklaunch- | Backend services |
| [chat/depot](https://clean-deploy.internal.justin.tv/#/chat/depot) | [chat-depot](http://jenkins-master-0.prod.us-west2.justin.tv/job/chat-depot/) | [chat-depot-deploy](http://jenkins-master-0.prod.us-west2.justin.tv/job/chat-depot-deploy/) | tmi-group-, tmi-main-nginx- | API for chat-related properties |
| [chat/tmi-js-client](https://clean-deploy.internal.justin.tv/#/chat/tmi-js-client) | [chat-tmi-js-client](http://jenkins-master-0.prod.us-west2.justin.tv/job/chat-tmi-js-client/) | [chat-tmi-js-client-deploy](http://jenkins-master-0.prod.us-west2.justin.tv/job/chat-tmi-js-client-deploy/) | rails-nginx- | Chat client for web |
| [chat/tmi-testing](https://clean-deploy.internal.justin.tv/#/chat/tmi-testing) | [chat-tmi-testing](http://jenkins-master-0.prod.us-west2.justin.tv/job/chat-tmi-testing/) | [chat-tmi-testing-deploy](http://jenkins-master-0.prod.us-west2.justin.tv/job/chat-tmi-testing-deploy/) | tmi-darklaunch- | Integration tests |
| [chat/im](https://clean-deploy.internal.justin.tv/#/chat/im) | [chat-im](http://jenkins-master-0.prod.us-west2.justin.tv/job/chat-im/) | [chat-im-deploy](http://jenkins-master-0.prod.us-west2.justin.tv/job/chat-im-deploy/) | *TBD* | Instant messaging client |

### Engineering Workflow
Here's a sample workflow.
- Make changes
  - Create a new branch from the latest master branch
    - `git checkout master`
    - `git fetch origin && git rebase origin/master`
    - `git checkout -b <branch-name>`
  - Change code
  - Update branch on remote repo
    - (`git push origin <branch-name>`)
  - Get code reviewed (on Github)
  - Check if build failed (on Jenkins) and fix any build errors
- Test changes
  - Test locally while developing
  - Test on [staging](http://www.twitch.tv/pho_test?tmi_host=tmi-darklaunch-7db8c8.sfo01.justin.tv&tmi_port=9667) by deploying your branch to staging environment (on Deploy)
  - (Optional) Test on [darklaunch](http://www.twitch.tv/pho_test?tmi_host=tmi-darklaunch-7db8c8.sfo01.justin.tv&tmi_port=6667) by deploying your branch to darklaunch environment (on Deploy)
  - Test on [canary](http://www.twitch.tv/pho_test?tmi_host=tmi-main-7e9188.sfo01.justin.tv&tmi_port=6667) by deploying your branch to prod-testing environment (on Deploy)
- Finalize changes
  - If confident, merge branch to master (on Github)
  - Deploy master branch to canary and production (on Deploy)
  - Optionally, keep our other environments updated and deploy master branch to staging, and darklaunch

### Environments
| Environment | Host(s) | Database | Description |
| ----------- | ------- | -------- | ----------- |
| Development | Your laptop! | Staging | -- |
| Staging | *TBD* | Staging | An environment on a remote host that simulates production configuration (no prod traffic) |
| Darklaunch | tmi-darklaunch-7db8c8 | Staging | An environment that a percentage of prod traffic connects to (*does not* impact prod traffic) |
| Canary | tmi-main-7e9188 | Prod | An environment that a percentage of prod traffic connect to (*does* impacts prod traffic) |
| Production | tmi-group-, tmi-main- | Prod | The environments that the rest of prod users connect to |

### Tools
Our deployable services use:
- [Manta](https://git.xarth.tv/release/manta-style) to build in a consistent, reproducible manner.
 - [Vagrant](https://www.vagrantup.com/) is a helpful tool to test Manta deployment locally.
- [Courier](https://git.xarth.tv/release/courier) to install to the right host boxes.
- [Deploy](https://git.xarth.tv/twitch/docs/blob/master/release/deploy.md) to manage the deployment workflow.
- [Jenkins](https://git.xarth.tv/release/jenkins-jobs) to monitor build/deploy jobs.

### Configuration
Within a repo, these are the file/folders to configure how we build and deploy a service:
- `.manta.json`
 - Define the dependencies needed to build the service (e.g. installing Go and godep).
 - Define the steps to build the service (e.g. running godep, running `go install` or a Makefile).
 - Call `cp -R courier <build folder>` if using courier hooks.
- `deploy.json`
 - Define the Jenkins job(s) to monitor builds and deploys.
 - Define the deployable environments (e.g. staging, darklaunch, prod).
 - Define the Consul service(s) to search for hosts to deploy to.
 - Use `"artifact": "tar"` to deploy a tarball. Tar deployments require a `courier/restart.sh` script.
- `jenkins.groovy`
 - Define Jenkins job names and what steps are actually run.
 - Use `TEMPLATE-autobuild` for build jobs and `TEMPLATE-deploy` for deploy jobs.
- `courier/*`
 - `post_install.sh` is a script that defines checks that should be run post-deployment on the deployed box.
 - `restart.sh` is a script that defines how to (re)start the service.
