TMI On-Call
-----------

### Configuration ###

TMI consists of 3 clusters:
- Main
  - consul-search -services tmi-goedge -tag environment-production -tag cluster-prod -format line
- Event
  - consul-search -services tmi-goedge -tag environment-production -tag cluster-event -format line
- Groups
  - consul-search -services tmi-goedge -tag environment-production -tag cluster-group -format line

and on each box there are several processes:

- IRC Edge
  - sudo svstat /etc/service/tmi_goedge_*
- Go Clue
  - sudo svstat /etc/service/tmi_goclue_*
- PubSub
  - sudo svstat /etc/service/tmi_pubsub_*
- Room
  - sudo svstat /etc/service/tmi_room_*
- HTTP Edge
  - sudo svstat /etc/service/tmi_http_edge_*

### DDOS Mitigation ###

If chat is dead, and you see a huge and ongoing spike in requests or connections, there are 2 common causes:

1. A misbehaving client application is overloading the system

  You can detect the most active OAuth client IDs by Goclue requests:
  
  ```
  ssh {HOSTNAME}
  cc@tmi4:~$ tail -n 10000 /var/log/jtv/tmi_goclue_6199.log | grep "clientid=\"" | perl -ne '$_ =~ /clientid="([^"]+)/;   print $1 . "\n";' | sort | uniq -c | sort -gr | head -n 10
  3832 11769 # 11769 is the client ID for the iPad
  2283 5880 # iPhone
  1293 20094 # Twitch Website
  ...
  ```

  To disable a specific OAuth client ID, update the `oauth_clientid_blacklist` config option for Goclue and restart Goclue.

2. A malicious user(s) are trying to overload the system

  TODO
