TMI Server Setup

1. Prepare Nagios: Schedule downtime in nagios for new hosts so you’re not alerting unnecessarily.
2. Register new boxes in Consul: Deploy puppet (origin/master) to new boxes to register them with Consul.
3. Update up the puppet configs: Update ops/puppet/modules/tmimod/manifests/init.pp with the new boxes (e.g. git show 1777f52). Deploy change.
4. Fetch code on new boxes: Deploy production code in jenkins (frontend: deploy.internal or clean-deploy.internal)
5. Register new boxes to pubsub: Update modules/files/files/conf/tmi_info (for prod cluster) or twitch_{cluster}_tmi_info. Deploy change to new boxes.
6. Start services: make sure that pubsub was upped before edge so that edge connects to it (rather than another server’s pubsub).
    - Test: Connect to chat on a new and an old box. Messages sent from messages sent from new->old should appear, but old->new should not. If you see messages from old->new, the edge on the new box may be connecting to old pubsub exchanges. 
7. Update other pubsubs with new boxes: Deploy the previous pubsub change in puppet to the rest of the boxes. Rolling restart pubsubs on new boxes so they’ll load new configs the new hosts.
    - Test: Connect to chat on a new and an old box. Messages sent from one should appear on the other.
8. Update Rails edge hosts: Update Rails (channels_helper.rb) with new IPs, along with Rails tests (e.g. git show a0ee95). Deploy change.
9. Update Nagios: Add alerts for new boxes and remove the scheduled downtime if everything looks good.
10. Update tests: Add new hosts to message reliability test (chat/tmi_testing/base/base.go).
