# Twitch Video Docs

:movie_camera: Top Level components of video :movie_camera:

 * __Ingest__ ( receive video from broadcasters)
 * __Transcode__ and Encoding ( convert video into s
 * __VOD__ ( video on demand version of the originally live video )
 * __Edge and Distribution__ ( distribute video globally, serve video files to viewers )
 * __PlayBack__ ( make video play back )
 * __Tools__ (Compilation of tools built to help us manage the video pipeline better)
 * __Video Operations__ ( Things related to operating the machines that serve video )


## 50K Foot View of the Video System

Very, very summarized version of how video comes from a broadcaster computer, all the way to a viewers screens.

This is the main summary of things, and glosses over details and subsystems. It's functions is simply a starting point to understanding the video system as a whole.




 * The **Broadcaster** sends video to Twitch using a tool like OBS, a console like a PS4, or a hardware video encoder. This tool sends a video signal captured from their game and cameras, via a protocol called **[RTMP](https://en.wikipedia.org/wiki/Real_Time_Messaging_Protocol)** to twitch [live.twitch.tv]
 * live.twitch.tv is an **Ingest Proxy Edge**. These proxies sit around the world to receive RTMP streams. The hosts forward the stream into a second tier of proxies.
 * **Ingest proxies** sit between ingest proxy edges and Ingest servers to balance out traffic between User's RTMP and **GoIngests** servers.
 * Ingest servers running **[GoIngest](https://git.xarth.tv/video/goingest)** receive the RTMP data. They first check if the user is authorized to stream, then inform **[Usher](https://git.xarth.tv/video/usher)/[digestion](https://git.xarth.tv/video/digestion)** of the state of the user's stream, and start buferring the stream.
 * **[Usher](https://git.xarth.tv/video/usher)/[digestion](https://git.xarth.tv/video/digestion)**, once aware of the video stream, announce that the user's video needs to be transcoded and served to viewers.
 * The announcement message, along other messages, are sent into a **RabbitMQ** queue. The message waits to be dispatched into a video worker which will start the conversion job.
 * A transcoding server running **[GoTranscoder](https://git.xarth.tv/video/gotranscoder)** will pick up a video job and, based on the channel settings, start a video conversion job (a "transcode"). This worker takes the RTMP input and produces multiple output files that allow video playback.
 * The transcoder will periodically fire HTTP callbacks to **video-api** boxes running **Usher**. This marks updates the stream state in the database and also performs instant replication if there are enough viewers.
 * Video files produced by the transcoder are served to the world via HTTP. First, the files are served by an _Origin_, a first tier of cache which serves this files. Then a Tier 1 layer acts as additional layer of cache , and finally, _edge servers_ copy replicas of video across the globe for distribution.
 * In parallel, the video files are sent into a **swift** object store and **S3**, where they're stored long term and used to play **VOD**'s or offline video on demand.
 * **Edge** servers are an even deeper level of cache, which will store video files from the most important stream in memory, and replicate them live across multiple servers across the world.
 * Then from a user's perspective. A viewer will open a platform of their choice, choose their favorite stream and ask **FIND**, an usher http endpoint, that they want to watch certain channel. Find responds with a playlist URL (list of files they should download to see the video) and the server where the user can get video from. This endpoint is in charge of telling a user in japan, to talk to a server in japan to download video.


:warning: There are more components and tools in the pipeline, from tools to manage servers, change the server replication tree to tell how video is replicated, other workers which do management tasks, api's to do more things around video etc.


# Links

The one handy list of links to the multitude of tools we use day to day.

 * **[Video Git](https://git.xarth.tv/video)** Video git repo
 * **[Phabricator](https://phabricator.internal.justin.tv)** Code reviews
 * **[Code Deploy](https://clean-deploy.internal.justin.tv/#/home)** to push code to servers.
 * **[Elastic Search](https://esproxy-cwlogs-prod.elasticbeanstalk.com)** to track stats
 * **[AWS console login](https://twitch-video-aws.signin.aws.amazon.com)** Video aws account
 * **[Grafana](https://grafana.internal.justin.tv/)** Dashboard UI to track stats around subsystems
 * **[Graphite](http://graphite.internal.justin.tv)** Also to track stats around systems, same data as grafana, older UI.
 * **[Nagios](https://nagios-clean.internal.justin.tv)** Alerting around systems and tools. If something goes wrong, this alerts
 * **[PagerDuty](https://twitchoncall.pagerduty.com/)** Best Site Ever. Nags engineer's phones when nagios alerts.
 * **[User Admin](https://admin.internal.twitch.tv/admin)** Web admin tool for user settings
 * **[Tameka](https://tameka-0.prod.us-west2.justin.tv:8081/)** UI that helps enable/disable ingest and edge hosts
 * **[Rep Tree Manager](http://hls1.sfo01.justin.tv:8081/#/backbone)** Replication tree manager.
 * **[AWS Config manager](https://awsconfigman-production.elasticbeanstalk.com)** Tool to manage configuration files for services running on AWS
 * **[Broadcaster Dashboard](https://broadcaster-staging.twitch.tv)** Debug tool to check broadcast statistics and debug live streams
 * **[Transcode Dashboard](https://transcode-elasticsearch.internal.twitch.tv/_plugin/kibana/)** Dashboard to monitor all things transcode
 * **[Live Proxy Dashboard](https://liveproxyapi-prod.elasticbeanstalk.com)** Dashboard to control ingest proxies
 * **[Usher](https://usher.twitch.tv/api_audit)** Main api to control video things
 * **[Rabbit](https://rabbit4.sfo01.justin.tv:15672)** Web ui to manage our message queues. where video jobs are routed
 * **[Airbrake](https://airbrake.io)** Tool used to push error logs and detect things breaking
 * **[Rollbar](https://rollbar.com)** Replacement for Airbrake. Also to detect things breaking
 * **[Systems Dashboard](https://dashboard.internal.justin.tv/)** Another dashboard, this one to control systems/ops things (owned by systems)
 * **[On Call Summary](https://link.twitch.tv/oncallsummary)** Log of issues that affected production, handled by on-call engineers
 * **[Video Research Tool](https://google.com)** Finds solutions to many problems posed day to day.


# Video Components

These are the larger components of the video system, and mostly links to documents and specs of individual components and repos around each larger component.

:warning: ** Docs for each component are mostly in their git repository, starting at the main README.md file**

:warning: ** Links to Technical specs, Architecture of Each component, And Production checklists are at the top of the README.md for those services that have such documentation. **

## Ingest
* **[Ingest Proxies documentation ](ingest_proxy.md)** DOcumentation of how proxies work
* **[Ingest Dev box setup ](ingest_setup.md)** Instructions on setting up a new developer environment for ingest
* **[Digestion ](https://git.xarth.tv/video/digestion/blob/master/pkg/dgn/dgn.md)** Broadcaster streams API documentation
* **[GoIngest](https://git.xarth.tv/video/goingest)** RTMP server handling incoming video data
* **[LiveProxyApi](https://git.xarth.tv/video/liveproxyapi)** API  to manage ingest proxies
* **[Channel Properties ](https://git.xarth.tv/video/thoth_channel_properties)** Api to manage settings for channels and broadcasters


## Transcode
* **[GoTrancoder ](https://git.xarth.tv/video/gotranscoder)** Transcode worker and dependencies.
* **[LibAVTwitch ](https://git.xarth.tv/video/libavtwitch)** Library to perform video Encoding
* **[Velen ](https://git.xarth.tv/video/velen)** Dashboard and api to debug streams and transcodes
* **[Novigrad ](https://git.xarth.tv/video/novigrad)** Predictive Transcodes API
* **[Streamlog ](https://git.xarth.tv/video/streamlog)**  Time Series where data from streams is stored. Velen's backend
* **[Streamlog Api ](https://git.xarth.tv/video/streamlog/tree/master/doc)** Streamlog API docs


## Video on Demand

* **[VODS](vod.md)** Description of the video vod system
* **[Ingest Dev box setup ](https://git.xarth.tv/video/spectre)** Service that enables offline playlists
* **[Upkeep](upkeep.md)** Description of how vods are muted
* **[Ingest Dev box setup ](https://git.xarth.tv/video/upkeepsegment)** Tool that helps muting VOD segments

## Edge and Distribution
* **[Usher](https://git.xarth.tv/video/usher)** Central api to control all things video
* **[HoseAPI ](https://git.xarth.tv/video/hosesapi)** Hose API
* **[Rep Management ](https://git.xarth.tv/video/hls_rep_management)** Tool that manages replication
* **[Raymundo](https://git.xarth.tv/video/raymundo)** Legacy Stuff :kappa:
* **[BirdCage](https://git.xarth.tv/video/birdcage)** RPC Interface to fetch routes from BIRD

## PlayBack
* **[Player UI ](https://git.xarth.tv/video/player-ui/blob/beta/README.md)** HTML5 player UI
* **[Flash Player ](https://git.xarth.tv/video/player-flash)** Flash player that displays video
* **[Twitch Player ](https://git.xarth.tv/video/twitch_player)** More docs on twitch's video player

## Tools
* **[CloudWatch Logs](logs.md)** Tool used to ship logs into cloudwatch
* **[SGauge](logs.md)** SGauge tool
* **[Vagrant](https://git.xarth.tv/video/vagrant)** Vagrant box with video running on it setup instructions
* **[AWS Beanstalks](https://git.xarth.tv/video/beanstalk-service-template)** Template with all settings to start a new beanstalk video service
* **[Kibana](https://git.xarth.tv/video/kibanadashboards)** Backup and tools to manage elasticsearch/kibana dashboards

## Operations
More to come here!



# Old Documentation



:ghost: [Wiki](https://twitchtv.atlassian.net/wiki/display/VID/Engineering+-+Video) is where old docs used to be. Just for reference
