
Ingest Proxies relay incoming ingest connections to ingest servers in SFO

----

### General Architecture

#### Ingest Proxies in SFO
* DNS: `live.twitch.tv`
* Haproxy Backends: `Ingest servers in SFO`
* Host Naming Convention: `ingest-proxy-*.sfo01.justin.tv`


#### Public Ingest Proxies outside of SFO

* DNS: `live-<pop>.twitch.tv`
* Haproxy Backends: `Ingest proxies in SFO`
* Host Naming Convention: `ingest-proxy-edge-*.<pop>.justin.tv`

#### Private Ingest Proxies outside of SFO
* DNS: `live-<pop>-priv.twitch.tv`
* Haproxy Backends: `Ingest proxies in SFO`
* Host Naming Convention: `ingest-proxy-edge-priv-*.<pop>.justin.tv`

----
### How do I bring up an Ingest Proxy?
* Systems team hands you an machine with naming convention described earlier.
* Ensure that consul is enabled on the host
* Puppet run with `sudo puppet agent --test` will install haproxy, consul-template, video_deps and proxy_monitor softwares using courier.
* Verify haproxy stats page, `http://oxygen:atom@<hostname>:2001/stats` for correct backends.
* Verify if the proxy_monitor is able to stream up by viewing its logs at `/var/log/jtv/proxy_monitor.log`.
* Ensure the host has a public IP. The proxy can be enabled with [Liveproxyapi UI](liveproxyapi.md).
*  Alternatively, an entry can be created in the respective DNS list for the host using either [dnsapi](https://git.xarth.tv/systems/self-service-dns/blob/master/API.md) or the [dashboard](https://dashboard.internal.justin.tv/dns)
* [Ganglia](https://ganglia-ec2.internal.justin.tv/) can be used to verify that the host is serving production traffic.

----
### Debugging an Ingest Proxy
* Haproxy can be started/stopped/restarted using `/etc/init.d/haproxy` script
* List of haproxy backends can be viewed in `/etc/haproxy/haproxy.dynamic.conf`
* If list of backends is empty, consul-template service might need a restart `sudo svc -t /etc/service/consul-template`.

----
### How do I disable and drain an Ingest Proxy?
#### If the proxy is outside SFO
* Before disabling an ingest proxy from its DNS ensure that there are other proxies listed in the DNS.
* The ingest proxy can be disabled using [Liveproxyapi UI](liveproxyapi.md).
* Alternatively, it can be removed from the DNS rotation using [dnsapi](https://git.xarth.tv/systems/self-service-dns/blob/master/API.md) or the [dashboard](https://dashboard.internal.justin.tv/dns)

#### If the proxy is in SFO
* The proxy can be removed from the SFO DNS following the steps above.
* The proxy is still listed as a backend to the proxies outside SFO.
* Its consul tag for the proxy needs to be changed to something that is not  `public` or `clean-public`. Here is an [example](https://git.xarth.tv/systems/puppet/blob/master/hiera/fqdn/live13.sfo01.justin.tv.yaml#L3).

