Getting Started on the Ingest Team
==================================

The guide I wish I'd had.

Setting up your mac
-------------------

 - Download XCode
 - Install the command-line xcode tools
     ```xcode-select --install```
 - Install go: https://golang.org/dl/
 - Set your ```$GOPATH``` to something like ```/Users/username/go``` (thats what everyone else does)
 - Setup your git stuff. Our git is hosted at https://git.xarth.tv
   - You'll probably have LDAP problems. Speak to IT about getting your LDAP account added to the relevant LDAP groups for github access
   - You'll probably have github problems. Speak to someone on the video team to get access to the relevant github groups
   - Get your .ssh stuff setup according to https://help.github.com/enterprise/2.3/user/articles/generating-ssh-keys/
 - Download VLC: http://www.videolan.org/vlc/index.html
 - Download homebrew: http://brew.sh/
 - Get the dependencies for transcoding: https://git.xarth.tv/video/libavtwitch/blob/develop/tools/osxdeps.sh
 - Reinstall cmake (don't ask): ```brew reinstall cmake```

Get started with OBS
--------------------

For a few of the setup tests, we'll need to be able to publish a test rtmp stream, either to twitch or to our own test RTMP servers. The easiest tool to do this with is OBS - the Open Broadcaster Software. You can grab OBS from: https://obsproject.com/download#mac

Now would also be a great time to setup a new twitch.tv account linked to your internal email. Once you create an account, *make sure you enable two-factor auth*. If you don't use your internal email or don't enable two-factor auth, you can't get your twitch account marked as a staff account. To request your account be marked as a staff account, email support. *BE WARNED* that you probably can't handle the responsibility.

You can easily setup a test stream to publish using OBS in a loop. Here is a simple file that you can use to publish to twitch: ```ask nick about big_buck_bunny.flv``` Select the "media source" and configure it to use a local file (pointing at big buck bunny flv)

Quick note: When you're publishing, make sure you turn your mic off. You might accidentally publish everything that's being said around you, which would be less than ideal.

Test that you can publish to twitch first, using your stream key an selecting "twitch" as the destination in the settings.

Setup the transcoder
--------------------

Now we'll get setup with some of the transcoder pieces. These pieces take streams from our ingest servers, transcode them, and make them available for the rest of twitch to distribute across the world.

The code can be found here: https://git.xarth.tv/video/libavtwitch

Make sure you have the go protocol buffer compiler and other deps:
 - ```go get -u github.com/golang/protobuf/{proto,protoc-gen-go}```
 - ```github.com/deckarep/golang-set```

Check it out in some workspace (I use /Users/nick/src as my workspace), and make sure it builds by running ```sh install.sh``` - this will create a new directory and build everything using cmake. libavtwitch will now be installed into /usr/local/ and be ready for use by other codebases, like the transcoder.

Next up is to setup the transcoder itself. The transcoder code lives here: https://git.xarth.tv/video/transcoder

In order to test the build and run of the transcoder, first make sure your OBS setup is up-and-running, and outputting a stream to your channel. The run the transcoder using: ```sh run.sh <your-channel>``` This should start outputting hls segments into the build/web/ directory in your transcode checkout directory. Validate this is working by viewing the medium-dvr.m3u8 using VLC

Setting up goingest
-------------------

Once you're setup correctly, you probably want to get goingest, the first part of the ingest stack. Its code is found here: https://git.xarth.tv/video/goingest

We use godep here for most top-level projects. godep has a known issue where it doesn't handle nested dependencies all requiring godep very well, so for lower-level libraries (like gortmp) we don't have a great godep setup. To see what godep is about, head to: github.com/tools/godep

That's also why its nice to setup goingest first - its going to pull down a whole bunch of our other go libraries, so you should get a pretty good overview of how everything is setup.

 - To get godep setup, run:
     ```go get github.com/tools/godep```

 - To get the goingest code, run:
     ```go get code.justin.tv/video/goingest```

You'll notice that code.justin.tv doesn't match the aws-git from before. That's because we have this cool service running at code.justin.tv that makes go get work nicely, and gives us a much nicer domain to go get from. Its the little things.

Now we'll setup your go path with the various projects required by goingest. To do this we'll use the handy feature of godep to restore the required versions of our software.
    - ```cd $GOPATH/src/code.justin.tv/video/goingest```
    - ```godep restore```

Once this is complete, you should see several more projects in code.justin.tv/video

Getting started with gortmp
---------------------------

gortmp is the custom go library we run on our ingest workers. It handles the lower-level tasks of accepting an rtmp connection, and serving incoming media streams to the relevant internal services. You should have gotten a checkout of gortmp when you installed goingest.

gortmp mainly exists as a library for goingest, but there are a few test cmds that you can use to run a basic rtmp server. Head into your gortmp checkout, and run:

 - ```go build -o rtmpserver cmd/rtmpserver/main.go```
 - ```go build -o rtmpworker cmd/rtmpserver/rtmpworker.go```

Now run the server ```./rtmpserver``` You should see output along the lines of ```server.go:86: info - Listener Addr: [::]:1935```

Now setup OBS to point at a custom streaming server (its in settings). For the URL, use ```rtmp://localhost:1935/app``` and for the stream key use ```teststream```. Publish a test video in a loop, as before.

Check your rtmpserver log. You'll see something like "new process created with PID", followed by a line that looks like ```server.go:86: info - Listener Addr: [::]:54212```

The goingest server uses a multi-process model for handling connections. This means that each stream is actually served by a completely different goingest worker process. The initial RTMP handshake is handled by goingest, but the management of the actual streams is handled by an individual worker. The gortmp test script mirrors this functionality, where main.go implements a basic RTMP handshake server, and rtmpworker actually handles the connection.

To connect and view your live stream, you'll need to note the port that the worker started on. In this case, my worker started on port 54212. To view the live stream in VLC, use the following URL: ```rtmp://localhost:54212/app/teststream```. Confirm that you can watch the OBS stream you setup.

Setup Phabricator
-----------------

We use Phabricator for code reviews. First, install it on your machine:

 - ```brew tap homebrew/php```
 - ```brew install php70```
 - ```brew install --HEAD homebrew/php/arcanist```

You can find more information about Phabricator here: https://sites.google.com/a/khanacademy.org/forge/for-developers/code-review-policy/using-phabricator

And we have a wiki page on the twitch development process here: https://twitchtv.atlassian.net/wiki/display/VID/Development+Process



Trivia
------

That smirking face is Kappa. Kappa was an intern who was a pretty decent guy, but because his image had a slight smirk he turned into something of a meme, and the community just went with it.

There is no difference between the black hoodies and the purple hoodies. They don't mean you're any cooler, they're just a different color because variety is the spice of life.

Our email is called Xarth because, back when the name for twitch was being decided, someone wrote a script to find all one-syllable domains that were available. When the shortlist was being created, Xarth was on it. Its not a joke, because Xarth is such a ridiculously bad name.
