# Live video

## Lifecycle of a stream

### Stream up
* User creates an account on the website
  * Creates a users row in the justintv_prod database
  * Create a stream key from the website
* User connects to an ingest point (`live.justin.tv`)
  * `live.justin.tv` is an haproxy load balancer that forwards RTMP to the video boxes.
* wowza POSTs to [Usher][1]'s (git.internal warning) `/stream/authorize` to verify the stream key
  * Uses event trigger to trigger `stream_authorize` event
    * Checks [sitedb](/web/sitedb.md) to see if stream key is valid
    * Do we need to delay?
    * Archives allowed?
  * Gets channel view count from mongodb
  * Inserts row into streams table
* wowza POSTs to Usher's `/flow/up` (also used by non-origin nodes)
  * Inserts/updates row in flows table
  * Initializes instant replication if necessary (memcache counter)
  * Send `cache_flow_up` event
    * Gets flow data from Usher
  * If origin, `cache_stream_up` event (all the following respond to `cache_stream_up`)
    * `amqp_callbacks`
      * sends `stream.up` message
        * StreamWorker
          * POST to `www-origin/live/callback`
          * POST to `irc.justin.tv`
    * Archives
      * Sends `archive.pull` message
        * New archive puller gets it?
    * Delay
      * Inserts entry into delays table
      * Sends `stream.delay` message
        * DelayWorker
          * Sleeps, then pushes the stream out to `live.justin.tv`
      * sends telegraph_exchange message
    * gametrans
      * Insert and update gametrans rows into usherdb
      * Sends `stream.gametrans` message to start worker for each new row
        * GametransWorker starts transcoding
    * `http_callbacks`
      * GET to `justin.tv/live/callback` with stream name
      * GET to `irc.justin.tv` with stream name
    * `start_preview`
      * Sends `stream.generate_preview` message
        * PreviewWorker generates a preview image, maintains queue
    * `waiting_viewers` (if instant replication)
      * Asks telegraph for waiting viewer count
      * `stream_up_with_waiting_viewers` event
        * Notifies [Mixpanel](/architecture/mixpanel.md) of stream info
      * `instant_rep.replicate_stream`
        * Do v2 instant replication
          * Insert rows into flows table for replications
        * Do v3 instant replication
          * inserts rows into flows table for replication
  * If origin, wait until instant replication is done and then `fire_ready` (memcache counter for the stream)
    * `cache_stream_ready` event
      * send `.up` message to `telegraph_exchange`

[1]: https://git.xarth.tv/video/usher

### Stream running
* wowza POSTs flow_send_viewer_counts (every 10 seconds)
  * `stream_heartbeat_info_by_id`
  * `live_viewer_count_by_channel_name`
  * Send `.viewer_count` message to `telegraph_exchange`
  * Send `stream.preview` message if necessary
    * NewPreviewWorker connects to stream and generates preview image

### Stream down
* wowza POSTs stream_down
  * Send `stream_down` event
    * `cascade_deletes`
      * Send `cache_flow_down` events for this node
      * Send `transcode_down` event
        * Delete from transcodes table for this stream
        * Send `stream_down` for each transcode
      * Delete from streams table for the stream
        * Delete from flows table for the stream's flows
      * Send `cache_flow_down` for all flows
        * Deletes authorization for the flow
      * Send `cache_stream_down` event for stream
        * StreamWorker POSTs to `www-origin/live/callback`
  * Delete flows for this stream
  * Send `cache_flow_down` event
* wowza POSTs archive_ready
    * Send `cache_archive_ready` event
      * Get metadata for archive
      * Send `archive.file_ready` message

### Wowza main loop (interacting w/ video usher)
Note that wowza seems to do all this stuff by spawning off lots of independent threads based on event callbacks. I have not dug into it yet.
These are all called periodically:

    GET node_revoked
    GET node_killed
    GET node_stream_counts
    GET node_akamai_streams
    POST flow_bulkupdate
    POST get_replications
    POST node_get_broadcast_parts
