# Cloudwatch Logs for Video

Video Engineering uses cloudwatch logs for central log aggregation and rudimentary processing. We also use AWS Elasticsearch and Kibana to perform further processing and allow for full text search of logs. Currently, logs are pushed by the cloudwatch logs agent from each individual service to the central cloudwatch logs service, and then a lambda job pulls those logs from the cloudwatch logs agent.

## Reaching the logs

The primary endpoints for Cloudwatch Logs direct access and elastic search are different, we use the standard AWS Console for direct access to cloudwatch logs and a custom proxy (to handle IAM) for our Elasticsearch Kibana instances.

### Cloudwatch Logs

All of our cloudwatch logs data is stored in one region currently, us-west-2.  The log retention time varies between services as we have not yet determined what our target log retention time is for services.

### Kibana

Our primary logs endpoint is:

    http://video-logs.internal.justin.tv/

This endpoint contains links to reach kibana on any AWS Elasticsearch instance in the video engineering AWS account.  It is specifically *not* intended to be used as a proxy to reach Elasticsearch directly, for that users should instead configure an IAM role use the ES apis directly.  Most logs will be located under the cloudwatchlogs domain, but there are a few others for various purposes.  If you're unsure of who owns what, you may need to ask around.

## Configuring Logging

There are two major components when considering setting up logging for your application.  First, you'll need to get the cloudwatch logs agent configured and deployed on the hosts which run your service.  The precise method by which the agent is configured and deploys varies based on how your software is deployed.  Next, you'll need to configure lambda to receive logs for your application and publish them to a cloudwatch logs domain.

### Cloudwatch logs agent

Instructions for elastic beanstalk and puppet are listed below, if your software is deployed via some other mechanism you'll need to come up with new steps to deploy.  If you need to come up with a custom mechanism, one thing to note is that we've mostly followed a convention of log group names with the following format:

    /twitch/<pop or region>/<service name>/<environmnent>

Ex:

    /twitch/sfo01/goingest/production
    /twitch/us-west-2/digestion/production

#### Puppet

1. 

#### Elastic Beanstalk

Copy `.ebextensions/cwl-*` from [video/digestion](https://git.xarth.tv/video/digestion) into your .ebextensions directory. This should automatically create agents that send your eb-activity and stdouterr logs to `/twitch/<aws region>/<environment name>`. Unfortunately there doesn't seem to be a clear way to specify your application name with cloudformation templates - if you know how, tell @jgarneau.
