# Starvation

Starvation will monitor the status of live streams. The tools is located in:

http://starvation.internal.justin.tv


## Cassandra console

Monitoring the status of the cassandra db storage is done via OpsCenter. This is the dashboard url for the starvation cluster:

http://starvation-cassandra-001.sfo01.justin.tv:8888/opscenter/index.html


## Checking Cassandra's Status

Nodetool is the tool to do most cassandra maintenance tasks. it's very easy to use  - running nodetool with no params will show the full help.

* To check the overall DB status:

`status` : this will tell the basic stuff - if the db nodes are up, space used, etc. 
 
 
* To know how each keysapce is behaving: 


`nodetool cfstats`: Prints data statistic of each column family, good to know read/write stats, latency, read counts, size of memory tables, disk tables, etc. 


`/nodetool cfhistograms starving events`: this will show read write latency stats, this in combination with iostat -x is useful to know if the db is slow cause the disks are overloaded.

`iostat -x`: Cassandra ,at least on stats10, is limited by disk speed, more than memory and cpu. Knowing how disks are doing is usually a good pointer.

## Delete data

This is key. cassandra doesn't delete entries on delete. Since it writes to an SStable, and this is immutable, It'll delete data by making entries a tombstone -  which is marking them as "deleted". 
Tombstones need to be cleared routinely

http://www.datastax.com/docs/1.1/dml/about_writes


## Repairing things

`nodetool repair`: This will fix things,clear deleted data(tombstones), take snapshots and reccreate data correctly from them. It is actually recommended to  runs every 10 days or so to clear tombstones and keep the cluster healthy. No parameters needed, works automagically. 


http://www.datastax.com/documentation/cassandra/2.0/cassandra/operations/ops_repair_nodes_c.html


`nodetool compact`: This is like a defrag + delete all deleted data. It will compact all sstables into a single one, and clear tombstones in the process. It is very I/O heavy.  But if there's a huge amount of tombstones it may be needed to be run.


`nodetool compactionstats`: After running nodetool compact - this will tell the progress of the current compaction task, percent of completion , what's it doing, and how long it'll take to finish.


`nodetool flush`: this will dump memtables into disk to an sstable . this is useful before restarting the db, makes it quicker.


## Tracing a query

This is useful to know why queries are slow or timing out, it will tell how things are being done.
It needs to run from the CQL shell :
cqlsh -u video

and from the shell
`cqlsh> tracing on;`

then running a query will print the query stats.

