# Upkeep Workers

*See also: [web/audible_magic_responses/](/web/audible_magic_responses/README.md)*

### Worker machines

the mute/unmute workers run on audio machines (audio3-9)
Audio 3 is the Test machine and videodev1 serves as staging.

Muted archives are stripped of audio. The files are split into a video file and an audio file saved as a backup,  then both are uploaded to the location of the original file. The cdn record is then expired so the next request retrieves a muted video file

### Seeing muted files with audio

the archive audio can be heard via twitch's admin panel
admin.internal.twitch.tv/admin

### Worker queues
upkeep_worker will pickup mute jobs from the worker.archive_audio_filter queue posted to rabbit4/5. This jobs are created as soon as the flv archive is recorded or the VOD recording is finalized. 

upkeep_unmute_worker will read for messages posted to worker.archive_audio_unmute_filter queue. This will start the process to merge the audio/video files, and restore it. 

### Unmutes
the admin panel has an archive viewer with a button that triggers an unmute.
Unmutes should be only done for approved files by legal


# Metadata descriptions


## Allow tag

AudibleMagic reports <Action>Allow</Action> for shareable songs. This songs have clearance to skip muting.

## Audible fields stored in the table audible_magic_responses

| Field | Audible magic xml value | Description
|--------|--------|--------|
| title | Audible xmlvalue IdDetails/Title | Title of the song
| performer | IdDetails/Performer | Performer of the song
| genre | IdDetails/Genre | Genre of the song
| artist | IdDetails/Music/Artist | Artist playing the song
| album_title | IdDetails/Music/AlbumTitle | Album title
| song | Song | Song Name
| isrc | Isrc | Song unique identifier
| match_offset_seconds  | IdDetails/MatchOffset | offset of the file at which the match was found
| match_duration_seconds | IdDetails/MatchDuration | Duration of the match
| scan_offset_seconds |  offset | offset at which the scan was started
| scan_duration_seconds | | for how long it was scanned, saved as chunk_duration which is 30 for flv, 6 for vod
| mute_offset_seconds | | For vods this is (offset - chunk_duration/2) and 0 for FLVs'
| mute_duration_seconds| | How much it is being muted - 6 mins for vods, 30 for FLVs

