

### RunBook for Rechat API

#### Where do I find Rechat API?
 * It is an AWS elasticbeanstalk application  - [Click Here](https://us-west-2.console.aws.amazon.com/elasticbeanstalk/home?region=us-west-2#/environment/dashboard?applicationName=rechat&environmentId=e-3533uaem9w)
 * The Load balancer for rechat is [here](https://us-west-2.console.aws.amazon.com/ec2/v2/home?region=us-west-2#LoadBalancers:search=awseb-e-3-AWSEBLoa-6DGJ5WNSJGE5)
 * Users access the API through CloudFront (CNAME: https://rechat.twitch.tv). The Cloudfront distribution can be found [here](https://console.aws.amazon.com/cloudfront/home?region=us-west-2#distribution-settings:E1O9XSVDTJIEA4)
 * Rechat queries for chats from Elasticsearch. The Elasticsearch cluster is [here](https://us-west-2.console.aws.amazon.com/es/home?region=us-west-2#rechat:dashboard)
 * Since elasticsearch does not cache search query results - we use Redis to store the search results (with a TTL of 5 minutes). The redis clusters are [here](https://us-west-2.console.aws.amazon.com/elasticache/home?region=us-west-2#cache-clusters:). Check for the ones that say "rechat"

#### Where can I see the Rechat API graphs ?
 * [http://grafana.prod.us-west2.justin.tv/dashboard/db/rechat-api](http://grafana.prod.us-west2.justin.tv/dashboard/db/rechat-api)
 * Alarms are set for the status_200 rate (Graph 1 - green), Exceptions rate (Graph 3) and redis_video_hit and redis_chunk_hit rates (Graph 2) (Redis caches both chat search query results - chunk_hit and
 video API results - video_hit)

#### Where can I see the API logs ?
* They can be found [here](https://us-west-2.console.aws.amazon.com/elasticbeanstalk/home?region=us-west-2#/environment/logs?applicationName=rechat&environmentId=e-3533uaem9w).
* You can also ssh into the rechat api boxes. To do that - first you need to download (this keypair)[https://us-west-2.console.aws.amazon.com/ec2/v2/home?region=us-west-2#KeyPairs:search=rechatapi;sort=keyName] and place it in your
~/.ssh. Also chmod to 0400. Next, download the (eb command line tool)[http://docs.aws.amazon.com/elasticbeanstalk/latest/dg/eb-cli3.html]. Create a temporary directory in your workspace
and then run `eb init` from there. Choose `us-west-2`, `rechat` (Application) and then `rechat` (Environment). Next, type `eb ssh` and then
ssh into one of the 15 boxes that run rechat API. Once inside the box, you can find the running docker container using `sudo docker inspect`. The application logs for that will be in `/var/log/eb-docker/containers/eb-current-app/<docker-id>-stdouterr.log`
