# Removing a misbehaving device from a swift host

A common reason for swift hosts to start misbehaving is one of the device's disk capacity filled up. Given S3 ingest is on the horizon, we typically just shoot misbehaving devices in the head to fix the issue. Here are the steps

## 1. Identify which device is misbehaving

You probably got paged or noticed in Ganglia that a particular swift object host looks borked. First, ssh to the host in question
```
ssh <swift object host>
```
To find exactly which device, do
```
df -h
```
Each row is a device. If one of these devices is close to 100% full that's your culprit. Note down that device's **filesystem path** (like /dev/sdz1) and **UUID** which is shown in the right column (like 0b0f23c2-5ace-4ed0-96c5-3548cfa027c0)

## 2. Unmount device
First unmount the device
```
sudo umount <filesystem path>
```
Now we need to tell this host to never mount this device on reboot
```
sudo vim /etc/fstab
```
In this file comment out the line corresponding to this device

Now reboot the host
```
sudo reboot # you'll have to re-ssh into the host after the reboot finishes
df -h # visually confirm that the device is no longer showing in this list
tail -F /var/log/jtv/object-server.log # also confirm that the service is still taking in requests and isn't completely dead or anything
```

Great, the device is unmounted. But swift still thinks it exists and will try to store data in it until we remove it from the ring.

## 3. Remove that device from the swift ring

Visit http://swift-proxy-001.sfo01.justin.tv:8077/swift/object to get a map of ID to UUID. On this page search for your UUIDs to grab all IDs that you want to remove.

Make a curl request with the device ID (use ID! not UUID) to be removed

```
curl -X DELETE http://swift-proxy-001.sfo01.justin.tv:8077/swift/object/<ID>?instant=true
```

## 4. Run the swift rebalance operation:

**Note:** Rebalance operations are very expensive. If you are removing multiple swift devices, you should unmount and remove them all from the ring first. When all your devices are removed from the ring, run rebalance

`curl -X POST http://swift-proxy-001.sfo01.justin.tv:8077/swift/object/rebalance`

## FAQ

Q: This describes how to remove a device from an object box. What if I need to remove a device from a container box?

A: The step to unmount the device from the container box is the same. Now when curling swift-proxy-001 in steps 3 and 4, replace `swift/object/...` with `swift/container/...` and everything else is the same
