# Audible Magic Responses Internal API

The audible magic video worker should scan archives and vods using Audible Magic, parse the Audible Magic XML
response, and POST the parsed data to Rails. This is the API for POSTing scan data to Rails.

## Contents

- [Audible Magic Response schema overview](#audible-magic-response-schema)

- **API**
  - [Creating AMRs for a vod or archive](#creating-amrs-for-a-vod-or-archive)
  - [View a list of AMRs for a vod or archive](#view-a-list-of-amrs-for-a-vod-or-archive)
  - [Update an AMR for a vod or archive](#update-an-amr-for-a-vod-or-archive)

## Audible Magic Response schema

```js
// audible_magic_responses table
//
// column                 | notes
// --------------------------
// title                  |
// performer              |
// genre                  |
// artist                 |
// album_title            |
// song                   |
// song_length_seconds    |
// isrc                   | "industry standard recording code"
// is_match               | determine if it passed or failed
// archive_id             | Should never have both an archive_id and vod_id
// vod_id                 |
//
// These offsets are relative to the file. For archives, that's the FLV chunk.
// For vods, it's the entire broadcast:
//
// match_offset_seconds   | When does the song start? (Comes from audible magic)
// match_duration_seconds | How many seconds is the song? (Comes from audible magic)
// scan_offset_seconds    | When did audible magic start scanning? (Comes from audible magic)
// scan_duration_seconds  | How long did audible magic scan? (Comes from audible magic)
// mute_offset_seconds    | When did the muting worker start muting? (Comes from muting worker)
// mute_duration_seconds  | How many seconds did the mute worker mute? (Comes from muting worker)
```

## Usage

### Creating AMRs for a vod or archive

These examples all show `vod`s. To create an archive for an FLV archive,
just change `vod_id` to `archive_id`.

#### Example match (where `is_match` is `true`):

```js
// POST /api/internal/audible_magic_responses
{
  "audible_magic_responses": [
    {
      "vod_id": 31415,
      "title": "Bohemian Rhapsody",
      "performer": "Queen",
      "genre": "Rock",
      "artist": "Queen",
      "album_title": "A Night At The Opera",
      "song": "Bohemian Rhapsody",
      "song_length_seconds": 555,
      "isrc": "QMFMG1335177",
      "is_match": true,
      "match_offset_seconds": 1440,
      "match_duration_seconds": 60,
      "scan_offset_seconds": 1300,
      "scan_duration_seconds": 3600,
      "mute_offset_seconds": 1440,
      "mute_duration_seconds": 300
    }, {
      "vod_id": 31415,
      "title": "This Town Ain't Big Enough For The Both Of Us",
      "performer": "Sparks",
      "genre": "Rock",
      "album_title": "Kimono My House",
      "song": "This Town Ain't Big Enough For The Both Of Us",
      "song_length_seconds": 186,
      "isrc": "GBCEN1300221",
      "is_match": true,
      "match_offset_seconds": 1440,
      "match_duration_seconds": 55,
      "scan_offset_seconds": 1300,
      "scan_duration_seconds": 3600,
      "mute_offset_seconds": 1440,
      "mute_duration_seconds": 300
    }
  ]
}

// Response: HTTP 201 Created
{
  "audible_magic_responses": [
    {
      "id": 15,
      "vod_id": 31415,
      "archive_id": null,
      "title": "Bohemian Rhapsody",
      "performer": "Queen",
      "genre": "Rock",
      "artist": "Queen",
      "album_title": "A Night At The Opera",
      "song": "Bohemian Rhapsody",
      "song_length_seconds": 555,
      "isrc": "QMFMG1335177",
      "is_match": true,
      "match_offset_seconds": 1440,
      "match_duration_seconds": 60,
      "scan_offset_seconds": 1300,
      "scan_duration_seconds": 3600,
      "mute_offset_seconds": 1440,
      "mute_duration_seconds": 300
    }, {
      "id": 16,
      "vod_id": 31415,
      "archive_id": null,
      "title": "This Town Ain't Big Enough For The Both Of Us",
      "performer": "Sparks",
      "genre": "Rock",
      "album_title": "Kimono My House",
      "song": "This Town Ain't Big Enough For The Both Of Us",
      "song_length_seconds": 186,
      "isrc": "GBCEN1300221",
      "is_match": true,
      "match_offset_seconds": 1440,
      "match_duration_seconds": 55,
      "scan_offset_seconds": 1300,
      "scan_duration_seconds": 3600,
      "mute_offset_seconds": 1440,
      "mute_duration_seconds": 300
    }
  ]
}
```

#### Example non-match (where `is_match` is `false`):

```js
// POST /api/internal/audible_magic_responses
{
  "audible_magic_responses": [
    {
      "vod_id": 31415,
      "is_match": false
    }
  ]
}

// Response: 201 Created
{
  "audible_magic_responses": [
    {
      "id": 10,
      "vod_id": 31415,
      "archive_id": null,
      "title": null,
      "performer": null,
      "genre": null,
      "artist": null,
      "album_title": null,
      "song": null,
      "song_length_seconds": null,
      "isrc": null,
      "is_match": false,
      "match_offset_seconds": null,
      "match_duration_seconds": null,
      "scan_offset_seconds": null,
      "scan_duration_seconds": null,
      "mute_offset_seconds": null,
      "mute_duration_seconds": null
    }
  ]
}
```

### View a list of AMRs for a vod or archive

These examples all show `vod`s. To create an archive for an FLV archive,
just change `vod_id` to `archive_id`.

```js
// GET /api/internal/audible_magic_responses?vod_id=31415
// Response: HTTP 200 OK
{
  "audible_magic_responses": [
    {
      "id": 22,
      "vod_id": 31415,
      "archive_id": null,
      "title": "Bohemian Rhapsody",
      "performer": "Queen",
      "genre": "Rock",
      "artist": "Queen",
      "album_title": "A Night At The Opera",
      "song": "Bohemian Rhapsody",
      "song_length_seconds": 555,
      "isrc": "QMFMG1335177",
      "is_match": true,
      "match_offset_seconds": 1440,
      "match_duration_seconds": 60,
      "scan_offset_seconds": 1300,
      "scan_duration_seconds": 3600,
      "mute_offset_seconds": 1440,
      "mute_duration_seconds": 300
    }, {
      "id": 23,
      "vod_id": 31415,
      "archive_id": null,
      "title": "This Town Ain't Big Enough For The Both Of Us",
      "performer": "Sparks",
      "genre": "Rock",
      "album_title": "Kimono My House",
      "song": "This Town Ain't Big Enough For The Both Of Us",
      "song_length_seconds": 186,
      "isrc": "GBCEN1300221",
      "is_match": true,
      "match_offset_seconds": 1440,
      "match_duration_seconds": 55,
      "scan_offset_seconds": 1300,
      "scan_duration_seconds": 3600,
      "mute_offset_seconds": 1440,
      "mute_duration_seconds": 300
    }
  ]
}
```

### Update an AMR for a vod or archive

You should update an AMR when unmuting a vod or archive.

These examples all show `vod`s. To create an archive for an FLV archive,
just change `vod_id` to `archive_id`.

**Note**: You may only update the `mute_offset_seconds` and `mute_duration_seconds`.

```js
// PUT /api/internal/audible_magic_responses/1235
{
  "audible_magic_response": {
    "mute_offset_seconds": null,
    "mute_duration_seconds": null
  }
}

// Response: HTTP 200 OK
{
  "audible_magic_response": {
    "id": 1235,
    "vod_id": 1234,
    "archive_id": null,
    "title": "Bohemian Rhapsody",
    "performer": "Queen",
    "genre": "Rock",
    "artist": "Queen",
    "album_title": "A Night At The Opera",
    "song": "Bohemian Rhapsody",
    "song_length_seconds": 555,
    "isrc": "QMFMG1335177",
    "is_match": true,
    "match_offset_seconds": 1440,
    "match_duration_seconds": 60,
    "scan_offset_seconds": 1300,
    "scan_duration_seconds": 3600,
    "mute_offset_seconds": null,
    "mute_duration_seconds": null
    }
  }
}
```
