# Resource Authorization

For any unanswered questions here, ask in #cartman on Slack or email our [mailing list](mailto:resource-authorization@justin.tv).

## Cartman

If you're a service owner and looking for a guide on how to integrate Cartman
authorization tokens for your service, we have a guide [here](https://docs.google.com/a/justin.tv/document/d/1_spjDG1J_D80Z0Q1dTPGZSyDG88UeMnJpb4Y3KLpzMg/edit?usp=sharing).

Our git repos are:

- [web/cartman](https://git.xarth.tv/web/cartman)
- [web/cartman-configs](https://git.xarth.tv/web/cartman-configs)
- [web/cartman-shim](https://git.xarth.tv/web/cartman-shim)

### Production Infrastructure

Cartman hosts are managed by an ASG in `twitch-web-aws`: `cartman-production-asg`

An ELB sits in front of all _cartman_ hosts, monitors the states of each
instance, and listens on port 443 (https):

- cartman-elb.prod.us-west2.justin.tv

All production `rails-nginx-aws` hosts running the _cartman-shim_ service each
including a copy of _cartman-configs_:

- rails-nginx-aws-*.prod.us-west2.justin.tv: AWS hosts

### Playbook

For any kind of service disruption, you'll either be alerted via Pagerduty, see
a spike in Rollbar errors or notice spikes/drops in [Grafana](http://grafana.prod.us-west2.justin.tv/dashboard/db/cartman) metrics.

**What to do when Cartman is down**

_cartman_ runs on port 8001 and _cartman-shim_ runs on port 14110 on production hosts.

Helpful commands:

- Check the logs for _cartman_: `tail -f /var/log/jtv/cartman.log`
- Check the logs for _cartman-shim_: `tail -f /var/log/jtv-cartman-shim.log`
- Check if _cartman_ is running: `sudo svstat /etc/service/cartman`
- check if _cartman-shim_ is running: `sudo svstat /etc/service/cartman-shim`
- Restart _cartman_: `sudo svc -t /etc/service/cartman`
- Restart _cartman-shim_: `sudo svc -t /etc/service/cartman-shim`

## Additional Links

- [Rollbar](https://rollbar.com/Twitch/Cartman/items/)
- [Pagerduty](https://twitchoncall.pagerduty.com/services/PKE6F0V)
- Consul:
  - [List of hosts](http://consul.internal.justin.tv/ui/dist/#/us-west2/nodes?filter=cartman)
  - Configuration variables: [AWS](http://consul.internal.justin.tv/ui/dist/#/us-west2/kv/settings/), [SFO01](http://consul.internal.justin.tv/ui/dist/#/sfo01/kv/settings/)
- Puppet:
  - _[cartman](https://git.xarth.tv/systems/puppet/tree/master/modules/twitch_cartman)_
  - _[cartman-shim](https://git.xarth.tv/systems/puppet/tree/master/modules/twitch_cartman)_
