# Experiments

## Performing Experiments with Bunkatsu

### Obtaining current experiments:
 * GET http://www.twitch.tv/splittest/current
 * Rails Console -> Bunkatsu.current
 
### Creating new experiments:
 * http://splittest1.sfo01.justin.tv:8080/
 * POST /new
   * experiment: 
     * name: name_of_experiment_in_snake_case
     * start_at: start date and time
     * end_at: end date and time, should be [far far into the future and then changed when science desires the experiment to end](../stats/experiments.md)
     * groups: Array of groups, weights must sum to 1 
       * name: group name
       * weight: weight in decimal
 * PATCH /edit/:id
 * GET /all
 * GET /current
       
Example payload:
```
{
  "experiment":
  {
    "name":"international_turbo_default_payment",
    "start_at":"2014-08-20T00:00:00+00:00",
    "end_at":"2014-12-01T00:00:00+00:00",
    "groups":[
      {
        "name":"month_paypal",
        "weight":0.2
      },
      {
        "name":"month_recurly",
        "weight":0.2},
      {
        "name":"month_xsolla",
        "weight":0.2},
      {
        "name":"year_paypal",
        "weight":0.2},
      {
        "name":"year_recurly",
        "weight":0.2
      }
    ]
  }
}
```

Example Edit:
```
 curl --request PATCH -H "Content-Type: application/json" -d '{"experiment": {"id":19,"name":"follow_notification","description":"Follow Notification Controls default notification state for new follows","start_at":"2014-11-10T00:00:00Z","end_at":"2014-12-30T00:00:00Z","groups":[{"name":"opt_in","weight":0.5},{"name":"opt_out","weight":0.5}]}}' http://splittest1.sfo01.justin.tv:8080/edit/19
```
