# web/web Canary

web/web has canary boxes that handle ~1% of all Rails production traffic. This allows testing a branch with actual traffic before pushing it to all production app servers.

## When to use the canary?

* Always, unless the next answer conflicts.

## When to avoid the canary?

* If you have a change that might involve some db schemas, memcache tomfoolery or anything that could break because builds across web/web are different
* Emergency type situations when we have to rollback or push a solution to prod
* If you are absolutely sure your change is low risk, use your best judgement

## How to deploy to the canary?

To deploy a branch to the Canary environment select `clean-production-canary` from the "Deploy to" dropdown in the Deploy UI. Then watch Rollbar/Graphite/New Relic/… to see how your branch affects production.

To manually test your change on the Canary boxes you can set a `force_canary_app_server=1` cookie in your browser.
Requests with the `force_canary_app_server=1` cookie will bypass Varnish and always run on a Canary box. The easiest way to do this is typing the following command in the Developer Console of your browser while on twitch.tv:

```
cookie.set('force_canary_app_server', 1);
```

To delete it:

```
cookie.remove('force_canary_app_server');
```

To ensure that Canary servers never run an outdated version they are also included in normal `clean-production` deployments.

Please merge the latest master before deploying your branch to the Canary environment and make sure your code is production-ready (CR passed, etc.).

Unfortunately we don't have a lot of host-specific graphs for web/web which is why the Canary-only dashboard doesn't provide too much insight: http://grafana.prod.us-west2.justin.tv/dashboard/db/rails-canary
It allows you to see if someone else deployed to clean-production (red annotations) after you deployed to clean-production-canary (blue annotations) and the impact on utilization your change has.

## How to find canary hosts?

Use [consul-search](https://git.xarth.tv/common/consul-search) with this command:

`consul-search -services web-rails-app -tag clean-production-canary -format=line`
