# web/web Code Review Guidelines

web/web deployments should always be 100% code-reviewed by another engineer before going into production.

## What to look for?

This is not an exhaustive list, but a typical code review should consist of at least the following checks:

* General
    * Does the code work?
    * Is it easily understandable?
    * Is there any repeated code that could be refactored?
    * Is the formatting / style consistent with the rest of the proejct?
    * Is there any commented out code that should be removed?
* Testing
    * Is the code testable?
    * Do adequate test cases exist?
* Security
    * Are all inputs checked / sanitized?
    * Are invalid parameters handled?
    * Check for SQL injection attacks: are any parameters passed directly to the database?
* Performance
    * Are there any [n+1 queries](https://secure.phabricator.com/book/phabcontrib/article/n_plus_one/)?

## What to do

If any of the checks above are not met, you should not approve the pull request and leave a comment explaining why. The author of the change should either fix the issue or provide an adequate explanation as to why they do not believe a fix is necessary. Note that "I'm too busy" is not a valid explanation!
